/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.resourcepack;

import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasSource;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.SingleAtlasSource;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class ModelModifiers {
    public static ModelAsset expandModel(ModelAsset asset, class_243 expansion) {
        return new ModelAsset(asset.parent(), asset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces().entrySet().stream().map(face -> {
            if (((ModelElement.Face)face.getValue()).uv().isEmpty()) {
                return Map.entry((class_2350)face.getKey(), new ModelElement.Face((List)ModelModifiers.getClampedDefaultUV(element.from(), element.to(), (class_2350)face.getKey()), ((ModelElement.Face)face.getValue()).texture(), ((ModelElement.Face)face.getValue()).cullface(), ((ModelElement.Face)face.getValue()).rotation(), ((ModelElement.Face)face.getValue()).tintIndex()));
            }
            return face;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), element.rotation(), element.shade(), element.lightEmission())).toList()), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion());
    }

    public static ModelAsset expandModelAndRotateUVLocked(ModelAsset asset, class_243 expansion, int x, int y) {
        return new ModelAsset(asset.parent(), asset.elements().map(a -> a.stream().map(element -> ModelModifiers.rotateAndExpandElement(element, expansion, x, y)).toList()), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion());
    }

    public static ModelElement rotateAndExpandElement(ModelElement element, class_243 expand, int xrot, int yrot) {
        class_243 tmp1 = element.from().method_61888(8.0).method_1037((float)Math.PI / 180 * (float)xrot).method_1024((float)(-Math.PI) / 180 * (float)yrot).method_61889(8.0);
        class_243 tmp2 = element.to().method_61888(8.0).method_1037((float)Math.PI / 180 * (float)xrot).method_1024((float)(-Math.PI) / 180 * (float)yrot).method_61889(8.0);
        class_243 from = new class_243(Math.min(tmp1.field_1352, tmp2.field_1352), Math.min(tmp1.field_1351, tmp2.field_1351), Math.min(tmp1.field_1350, tmp2.field_1350));
        class_243 to = new class_243(Math.max(tmp1.field_1352, tmp2.field_1352), Math.max(tmp1.field_1351, tmp2.field_1351), Math.max(tmp1.field_1350, tmp2.field_1350));
        EnumMap<class_2350, ModelElement.Face> faces = new EnumMap<class_2350, ModelElement.Face>(class_2350.class);
        for (Map.Entry face : element.faces().entrySet()) {
            List<Float> uv;
            int tmp;
            class_2350 dir = (class_2350)face.getKey();
            class_2350 dirx = (class_2350)face.getKey();
            if (dir.method_10166() != class_2350.class_2351.field_11048) {
                for (tmp = (360 + xrot) % 360; tmp > 0; tmp -= 90) {
                    dir = dir.method_35834(class_2350.class_2351.field_11048);
                }
            }
            dirx = dir;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                for (tmp = (360 + yrot) % 360; tmp > 0; tmp -= 90) {
                    dir = dir.method_35833(class_2350.class_2351.field_11052);
                }
            }
            if ((uv = ((ModelElement.Face)face.getValue()).uv()).isEmpty()) {
                uv = ModelModifiers.getClampedDefaultUV(from, to, dir);
            } else {
                int rot = 0;
                if (((class_2350)face.getKey()).method_10166() == class_2350.class_2351.field_11048) {
                    rot += xrot;
                }
                if (dirx.method_10166() == class_2350.class_2351.field_11052) {
                    rot -= yrot;
                }
                rot += 360;
                while (rot > 0) {
                    Float u1 = (Float)uv.get(0);
                    Float v1 = (Float)uv.get(1);
                    Float u2 = (Float)uv.get(2);
                    Float v2 = (Float)uv.get(3);
                    uv = List.of(v2, Float.valueOf(16.0f - u1.floatValue()), v1, Float.valueOf(16.0f - u2.floatValue()));
                    rot -= 90;
                }
                uv = List.of(Float.valueOf(Math.clamp(Math.min(((Float)uv.get(0)).floatValue(), ((Float)uv.get(2)).floatValue()), 0.0f, 16.0f)), Float.valueOf(Math.clamp(Math.min(((Float)uv.get(1)).floatValue(), ((Float)uv.get(3)).floatValue()), 0.0f, 16.0f)), Float.valueOf(Math.clamp(Math.max(((Float)uv.get(0)).floatValue(), uv.get(2).floatValue()), 0.0f, 16.0f)), Float.valueOf(Math.clamp(Math.max(uv.get(1).floatValue(), uv.get(3).floatValue()), 0.0f, 16.0f)));
            }
            faces.put(dir, new ModelElement.Face((List)uv, ((ModelElement.Face)face.getValue()).texture(), ((ModelElement.Face)face.getValue()).cullface(), ((ModelElement.Face)face.getValue()).rotation(), ((ModelElement.Face)face.getValue()).tintIndex()));
        }
        return new ModelElement(from.method_1020(expand), to.method_1019(expand), faces, element.rotation(), element.shade(), element.lightEmission());
    }

    public static void createSignModel(ResourcePackBuilder builder, String namespace, String name, AtlasAsset.Builder atlas) {
        class_2960 textureRegular = class_2960.method_60655((String)namespace, (String)("entity/signs/" + name));
        class_2960 textureHanging = class_2960.method_60655((String)namespace, (String)("entity/signs/hanging/" + name));
        atlas.add((AtlasSource)new SingleAtlasSource(textureRegular, Optional.empty()));
        atlas.add((AtlasSource)new SingleAtlasSource(textureHanging, Optional.empty()));
        builder.addData(AssetPaths.model((class_2960)class_2960.method_60655((String)namespace, (String)("block_sign/" + name + "_sign.json"))), (WritableAsset)ModelAsset.builder().parent(class_2960.method_60655((String)"factorytools", (String)"block_sign/template_sign")).texture("sign", textureRegular.toString()).build());
        builder.addData(AssetPaths.model((class_2960)class_2960.method_60655((String)namespace, (String)("block_sign/" + name + "_wall_sign.json"))), (WritableAsset)ModelAsset.builder().parent(class_2960.method_60655((String)"factorytools", (String)"block_sign/template_wall_sign")).texture("sign", textureRegular.toString()).build());
        builder.addData(AssetPaths.model((class_2960)class_2960.method_60655((String)namespace, (String)("block_sign/" + name + "_hanging_sign.json"))), (WritableAsset)ModelAsset.builder().parent(class_2960.method_60655((String)"factorytools", (String)"block_sign/template_hanging_sign")).texture("sign", textureHanging.toString()).build());
        builder.addData(AssetPaths.model((class_2960)class_2960.method_60655((String)namespace, (String)("block_sign/" + name + "_wall_hanging_sign.json"))), (WritableAsset)ModelAsset.builder().parent(class_2960.method_60655((String)"factorytools", (String)"block_sign/template_wall_hanging_sign")).texture("sign", textureHanging.toString()).build());
    }

    public static FloatList getClampedDefaultUV(class_243 from, class_243 to, class_2350 facing) {
        FloatList list = ModelModifiers.getDefaultUV(from, to, facing);
        return FloatList.of((float[])new float[]{Math.clamp(list.getFloat(0), 0.0f, 16.0f), Math.clamp(list.getFloat(1), 0.0f, 16.0f), Math.clamp(list.getFloat(2), 0.0f, 16.0f), Math.clamp(list.getFloat(3), 0.0f, 16.0f)});
    }

    public static FloatList getDefaultUV(class_243 from, class_243 to, class_2350 facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> FloatList.of((float[])new float[]{(float)from.field_1352, 16.0f - (float)to.field_1350, (float)to.field_1352, 16.0f - (float)from.field_1350});
            case class_2350.field_11036 -> FloatList.of((float[])new float[]{(float)from.field_1352, (float)from.field_1350, (float)to.field_1352, (float)to.field_1350});
            case class_2350.field_11043 -> FloatList.of((float[])new float[]{16.0f - (float)to.field_1352, 16.0f - (float)to.field_1351, 16.0f - (float)from.field_1352, 16.0f - (float)from.field_1351});
            case class_2350.field_11035 -> FloatList.of((float[])new float[]{(float)from.field_1352, 16.0f - (float)to.field_1351, (float)to.field_1352, 16.0f - (float)from.field_1351});
            case class_2350.field_11039 -> FloatList.of((float[])new float[]{(float)from.field_1350, 16.0f - (float)to.field_1351, (float)to.field_1350, 16.0f - (float)from.field_1351});
            case class_2350.field_11034 -> FloatList.of((float[])new float[]{16.0f - (float)to.field_1350, 16.0f - (float)to.field_1351, 16.0f - (float)from.field_1350, 16.0f - (float)from.field_1351});
        };
    }
}

