/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.virtualentity.emuvanilla.poly;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.PolyModelInstance;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.model.EntityModel;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.model.Model;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.model.ModelPart;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_4048;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ModelHandle<T extends class_1297> {
    private final Map<ModelPart, ItemDisplayElement> elements = new IdentityHashMap<ModelPart, ItemDisplayElement>();
    private final ElementHolder holder;
    private final class_243 offset;
    private PolyModelInstance<EntityModel<T>> model;
    private boolean hurt = false;
    private boolean hidden = false;

    public <X extends EntityModel<T>> ModelHandle(ElementHolder holder, PolyModelInstance<X> model, class_4048 dimensions, class_243 offset) {
        this(holder, offset);
        this.setModel(model, dimensions);
    }

    public ModelHandle(ElementHolder holder, class_243 offset) {
        this.holder = holder;
        this.offset = offset;
    }

    public <X extends EntityModel<T>> void setModel(PolyModelInstance<X> model, class_4048 dimensions) {
        if (this.model == model) {
            return;
        }
        if (!this.hidden) {
            this.updateElements(model, dimensions);
        }
        this.model = model;
    }

    public <X extends EntityModel<T>> void setModelAndShow(PolyModelInstance<X> model, class_4048 dimensions) {
        if (this.model != model || this.hidden) {
            this.updateElements(model, dimensions);
        }
        this.hidden = false;
        this.model = model;
    }

    public void setHidden(boolean hidden, class_4048 dimensions) {
        if (this.hidden == hidden) {
            return;
        }
        this.hidden = hidden;
        if (!hidden) {
            this.updateElements(this.model, dimensions);
        } else {
            this.removeAllElements();
        }
    }

    private void removeAllElements() {
        for (ItemDisplayElement old : this.elements.values()) {
            this.holder.removeElement((VirtualElement)old);
        }
        this.elements.clear();
    }

    private <X extends EntityModel<T>> void updateElements(PolyModelInstance<X> model, class_4048 dimensions) {
        IdentityHashMap<ModelPart, ItemDisplayElement> oldElements = new IdentityHashMap<ModelPart, ItemDisplayElement>(this.elements);
        this.elements.clear();
        for (ModelPart part : ((Model)model.model()).getParts()) {
            class_1799 stack = model.modelParts().apply(part);
            if (stack == null) continue;
            ItemDisplayElement element = oldElements.get(part);
            if (element == null) {
                element = ItemDisplayElementUtil.createSimple(stack);
                element.setDisplaySize(dimensions.comp_2185() * 2.0f, dimensions.comp_2186() * 2.0f);
                element.setInterpolationDuration(1);
                element.setTeleportDuration(3);
                element.setViewRange(2.0f);
                element.setOffset(this.offset);
            } else {
                element.setItem(stack);
                oldElements.remove(part);
            }
            this.elements.put(part, element);
            this.holder.addElement((VirtualElement)element);
        }
        for (ItemDisplayElement old : oldElements.values()) {
            this.holder.removeElement((VirtualElement)old);
        }
    }

    public void update(T entity, Matrix4fStack mat) {
        mat.pushMatrix();
        if (entity instanceof class_1309) {
            boolean hurt;
            class_1309 livingEntity = (class_1309)entity;
            boolean bl = hurt = livingEntity.field_6235 > 0 || livingEntity.field_6213 > 0;
            if (this.hurt != hurt) {
                this.hurt = hurt;
                Function<ModelPart, class_1799> map = hurt ? this.model.damagedModelParts() : this.model.modelParts();
                for (Map.Entry<ModelPart, ItemDisplayElement> entry : this.elements.entrySet()) {
                    entry.getValue().setItem(map.apply(entry.getKey()));
                }
            }
        }
        this.model.model().setAngles(entity);
        this.model.model().render(mat, this::updateElement);
        mat.popMatrix();
    }

    private void updateElement(ModelPart part, Matrix4f matrix4f, boolean hidden) {
        ItemDisplayElement element = this.elements.get(part);
        if (element == null) {
            return;
        }
        if (hidden) {
            this.holder.removeElement((VirtualElement)element);
        } else {
            element.setTransformation(matrix4f);
            element.startInterpolationIfDirty();
            this.holder.addElement((VirtualElement)element);
        }
    }
}

