/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.block.model.generic;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.factorytools.api.util.ResourceUtils;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateMultiPartDefinition;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import net.minecraft.class_6010;
import net.minecraft.class_6011;
import net.minecraft.class_6012;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockStateModelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockStateModelManager.class);
    private static final Map<class_2680, List<ModelGetter>> MAP = new HashMap<class_2680, List<ModelGetter>>();
    private static final Map<class_2680, class_2394> PARTICLE = new HashMap<class_2680, class_2394>();
    public static final Map<String, Map<String, List<StateModelVariant>>> UV_LOCKED_MODELS = new HashMap<String, Map<String, List<StateModelVariant>>>();

    public static List<ModelGetter> get(class_2680 state) {
        return MAP.getOrDefault(state, List.of());
    }

    public static class_2394 getParticle(class_2680 state) {
        return PARTICLE.getOrDefault(state, (class_2394)class_2398.field_11231);
    }

    public static void addBlock(class_2960 identifier, class_2248 block) {
        try {
            ArrayList<class_3545<List<class_2715>, List<ModelData>>> list;
            class_5819 rand = class_5819.method_43049((long)123L);
            byte[] data = ResourceUtils.getJarData("assets/" + identifier.method_12836() + "/blockstates/" + identifier.method_12832() + ".json");
            DataResult decoded = BlockStateAsset.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8)));
            BlockStateAsset modelDef = (BlockStateAsset)((Pair)decoded.getOrThrow()).getFirst();
            if (modelDef.variants().isPresent()) {
                list = new ArrayList<class_3545<List<class_2715>, List<ModelData>>>();
                BlockStateModelManager.parseVariants(block, (Map<String, List<StateModelVariant>>)((Map)modelDef.variants().get()), list);
                for (class_3545<class_2715, List<ModelData>> class_35452 : list) {
                    for (class_2680 state : block.method_9595().method_11662()) {
                        if (!((class_2715)class_35452.method_15442()).method_11760(state)) continue;
                        MAP.put(state, List.of(ModelGetter.of((List)class_35452.method_15441())));
                        if (((List)class_35452.method_15441()).isEmpty()) continue;
                        PARTICLE.put(state, (class_2394)new class_2392(class_2398.field_11218, ((ModelData)((List)class_35452.method_15441()).getFirst()).stack));
                    }
                }
            }
            if (modelDef.multipart().isPresent()) {
                list = new ArrayList();
                BlockStateModelManager.parseMultipart(block, (List)modelDef.multipart().get(), list);
                for (class_3545 class_35453 : list) {
                    block5: for (class_2680 state : block.method_9595().method_11662()) {
                        for (class_2715 pred : (List)class_35453.method_15442()) {
                            if (!pred.method_11760(state)) continue;
                            ArrayList<ModelGetter> objects = new ArrayList<ModelGetter>();
                            if (MAP.containsKey(state)) {
                                objects.addAll((Collection)MAP.get(state));
                            }
                            objects.add(ModelGetter.of((List)class_35453.method_15441()));
                            MAP.put(state, objects);
                            if (objects.isEmpty() || PARTICLE.containsKey(state)) continue block5;
                            PARTICLE.put(state, (class_2394)new class_2392(class_2398.field_11218, ((ModelGetter)objects.getFirst()).getModel((class_5819)rand).stack));
                            continue block5;
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to decode model for {}", (Object)identifier, (Object)e);
        }
    }

    private static void parseMultipart(class_2248 block, List<StateMultiPartDefinition> multiPartDefinition, ArrayList<class_3545<List<class_2715>, List<ModelData>>> list) {
        for (StateMultiPartDefinition part : multiPartDefinition) {
            class_2715 predicate;
            ArrayList<class_2715> preds = new ArrayList<class_2715>();
            if (part.when().or().isPresent()) {
                for (Map x : (List)part.when().or().get()) {
                    class_2715 predicate2 = class_2715.method_11758((class_2248)block);
                    BlockStateModelManager.applyWhenMultipart(predicate2, block, x);
                    preds.add(predicate2);
                }
            }
            if (part.when().and().isPresent()) {
                predicate = class_2715.method_11758((class_2248)block);
                for (Map x : (List)part.when().and().get()) {
                    BlockStateModelManager.applyWhenMultipart(predicate, block, x);
                }
                preds.add(predicate);
            }
            if (part.when().base().isPresent()) {
                predicate = class_2715.method_11758((class_2248)block);
                BlockStateModelManager.applyWhenMultipart(predicate, block, (Map)part.when().base().get());
                preds.add(predicate);
            }
            if (preds.isEmpty()) {
                preds.add(class_2715.method_11758((class_2248)block));
            }
            List<ModelData> modelData = BlockStateModelManager.parseBaseVariants(part.apply());
            list.add((class_3545<List<class_2715>, List<ModelData>>)new class_3545(preds, modelData));
        }
    }

    private static void applyWhenMultipart(class_2715 predicate, class_2248 block, Map<String, String> x) {
        for (Map.Entry<String, String> entry : x.entrySet()) {
            class_2769 prop = block.method_9595().method_11663(entry.getKey());
            if (prop == null) continue;
            Set<String> split = Set.of(entry.getValue().split("\\|"));
            predicate.method_11762(prop, y -> split.contains(prop.method_11901((Comparable)y)));
        }
    }

    private static void parseVariants(class_2248 block, Map<String, List<StateModelVariant>> modelDef, ArrayList<class_3545<class_2715, List<ModelData>>> list) {
        BlockStateModelManager.parseVariants(block, modelDef, (class_2715 a, List<StateModelVariant> b) -> {
            List<ModelData> modelData = BlockStateModelManager.parseBaseVariants(b);
            list.add(new class_3545(a, modelData));
        });
    }

    public static void parseVariants(class_2248 block, Map<String, List<StateModelVariant>> modelDef, BiConsumer<class_2715, List<StateModelVariant>> consumer) {
        block0: for (Map.Entry<String, List<StateModelVariant>> pair : modelDef.entrySet()) {
            String[] stateMap = pair.getKey().split(",");
            class_2715 predicate = class_2715.method_11758((class_2248)block);
            for (String statePair : stateMap) {
                if (statePair.isEmpty()) continue;
                String[] split = statePair.split("=", 2);
                class_2769 prop = block.method_9595().method_11663(split[0]);
                if (prop == null) continue block0;
                predicate.method_11762(prop, x -> prop.method_11901((Comparable)x).equals(split[1]));
            }
            consumer.accept(predicate, pair.getValue());
        }
    }

    private static List<ModelData> parseBaseVariants(List<StateModelVariant> value) {
        ArrayList<ModelData> modelData = new ArrayList<ModelData>();
        for (StateModelVariant v : value) {
            if (v.uvlock()) {
                class_2960 modelId = v.model().method_48331("_uvlock_" + v.x() + "_" + v.y());
                class_1799 stack = ItemDisplayElementUtil.getModel(modelId);
                modelData.add(new ModelData(stack, (Quaternionfc)new Quaternionf(), v.weigth()));
                UV_LOCKED_MODELS.computeIfAbsent(v.model().method_12836(), x -> new HashMap()).computeIfAbsent(v.model().method_12832(), x -> new ArrayList()).add(v);
                continue;
            }
            class_1799 stack = ItemDisplayElementUtil.getModel(v.model());
            modelData.add(new ModelData(stack, (Quaternionfc)new Quaternionf().rotateY((float)(-Math.PI) / 180 * (float)v.y()).rotateX((float)Math.PI / 180 * (float)v.x()), v.weigth()));
        }
        return modelData;
    }

    public static interface ModelGetter {
        public ModelData getModel(class_5819 var1);

        public static ModelGetter of(List<ModelData> data) {
            if (data.size() == 1) {
                return new SingleGetter(data.get(0));
            }
            return WeightedGetter.create(data);
        }
    }

    public record ModelData(class_1799 stack, Quaternionfc quaternionfc, int weight) {
    }

    private record WeightedGetter(class_6012<ModelData> data, int weightedSum) implements ModelGetter
    {
        public static ModelGetter create(List<ModelData> data) {
            ArrayList<class_6010> list = new ArrayList<class_6010>();
            for (ModelData d : data) {
                list.add(new class_6010((Object)d, d.weight));
            }
            int x = class_6011.method_34984(list, class_6010::comp_2543);
            return new WeightedGetter((class_6012<ModelData>)class_6012.method_34988(list), x);
        }

        @Override
        public ModelData getModel(class_5819 random) {
            return (ModelData)this.data.method_66216(random);
        }
    }

    private record SingleGetter(ModelData data) implements ModelGetter
    {
        @Override
        public ModelData getModel(class_5819 random) {
            return this.data;
        }
    }
}

