/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.virtualentity;

import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2739;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public class FastItemDisplayElement
extends LodItemDisplayElement {
    private final ObjectOpenCustomHashSet<class_3244> fastPlayers = new ObjectOpenCustomHashSet(CommonImplUtils.IDENTITY_HASH);
    private class_1799 fastItemStack = class_1799.field_8037;
    private int fastItemDistance = Integer.MAX_VALUE;
    private class_2596<class_2602> fastPacket;
    private class_2596<class_2602> slowPacket;

    public FastItemDisplayElement(class_1799 stack) {
        this.setItem(stack);
    }

    public FastItemDisplayElement() {
    }

    public void setFastItem(class_1799 stack, int distance) {
        this.fastItemStack = stack;
        this.fastPlayers.clear();
        this.getDataTracker().setDirty(DisplayTrackedData.Item.ITEM, true);
        this.fastItemDistance = distance * distance;
        this.fastPacket = new class_2739(this.getEntityId(), List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Item.ITEM, (Object)this.fastItemStack)));
    }

    public void setItem(class_1799 stack) {
        super.setItem(stack);
        this.slowPacket = new class_2739(this.getEntityId(), List.of(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Item.ITEM, (Object)this.getItem())));
    }

    protected void sendChangedTrackerEntries(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        double d;
        super.sendChangedTrackerEntries(player, packetConsumer);
        if (isEnabled && (d = this.getSquaredDistance(player.field_13987)) > (double)this.fastItemDistance) {
            packetConsumer.accept(this.fastPacket);
            this.fastPlayers.add((Object)player.field_13987);
        }
    }

    public void tick() {
        super.tick();
        if (isEnabled) {
            for (class_3244 player : Objects.requireNonNull(this.getHolder()).getWatchingPlayers()) {
                double d = this.getSquaredDistance(player);
                if (d > (double)this.fastItemDistance) {
                    if (!this.fastPlayers.add((Object)player)) continue;
                    player.method_14364(this.fastPacket);
                    continue;
                }
                if (!this.fastPlayers.remove((Object)player)) continue;
                player.method_14364(this.slowPacket);
            }
        } else {
            for (class_3244 player : this.fastPlayers) {
                player.method_14364(this.slowPacket);
            }
            this.fastPlayers.clear();
        }
    }
}

