/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.virtualentity.emuvanilla.animation;

import eu.pb4.factorytools.api.virtualentity.emuvanilla.animation.AnimationDefinition;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.animation.Keyframe;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.animation.Transformation;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.model.ModelPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_3532;
import net.minecraft.class_7094;
import org.joml.Vector3f;

public class Animation {
    private final AnimationDefinition definition;
    private final List<TransformationEntry> entries;
    private final Vector3f vec = new Vector3f();

    private Animation(AnimationDefinition definition, List<TransformationEntry> entries) {
        this.definition = definition;
        this.entries = entries;
    }

    static Animation of(ModelPart root, AnimationDefinition definition) {
        ArrayList<TransformationEntry> list = new ArrayList<TransformationEntry>();
        Function<String, ModelPart> function = root.createPartGetter();
        for (Map.Entry<String, List<Transformation>> entry : definition.boneAnimations().entrySet()) {
            String string = entry.getKey();
            List<Transformation> list2 = entry.getValue();
            ModelPart modelPart = function.apply(string);
            if (modelPart == null) {
                throw new IllegalArgumentException("Cannot animate " + string + ", which does not exist in model");
            }
            for (Transformation transformation : list2) {
                list.add(new TransformationEntry(modelPart, transformation.target(), transformation.keyframes()));
            }
        }
        return new Animation(definition, List.copyOf(list));
    }

    public void applyStatic() {
        this.apply(0L, 1.0f);
    }

    public void applyWalking(float limbSwingAnimationProgress, float limbSwingAmplitude, float f, float g) {
        long l = (long)(limbSwingAnimationProgress * 50.0f * f);
        float h = Math.min(limbSwingAmplitude * g, 1.0f);
        this.apply(l, h);
    }

    public void apply(class_7094 animationState, float age) {
        this.apply(animationState, age, 1.0f);
    }

    public void apply(class_7094 animationState, float age, float speedMultiplier) {
        animationState.method_41323(state -> this.apply((long)((float)state.method_61400(age) * speedMultiplier), 1.0f));
    }

    public void apply(long timeInMilliseconds, float scale) {
        float f = this.getRunningSeconds(timeInMilliseconds);
        for (TransformationEntry transformationEntry : this.entries) {
            transformationEntry.apply(f, scale, this.vec);
        }
    }

    private float getRunningSeconds(long timeInMilliseconds) {
        float f = (float)timeInMilliseconds / 1000.0f;
        return this.definition.looping() ? f % this.definition.lengthInSeconds() : f;
    }

    private record TransformationEntry(ModelPart part, Transformation.Target target, Keyframe[] keyframes) {
        public void apply(float runningSeconds, float scale, Vector3f vec) {
            int i = Math.max(0, class_3532.method_15360((int)0, (int)this.keyframes.length, index -> runningSeconds <= this.keyframes[index].timestamp()) - 1);
            int j = Math.min(this.keyframes.length - 1, i + 1);
            Keyframe keyframe = this.keyframes[i];
            Keyframe keyframe2 = this.keyframes[j];
            float f = runningSeconds - keyframe.timestamp();
            float g = j != i ? class_3532.method_15363((float)(f / (keyframe2.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
            keyframe2.interpolation().apply(vec, g, this.keyframes, i, j, scale);
            this.target.apply(this.part, vec);
        }
    }
}

