/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.block.model.generic;

import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_811;

public class BlockStateModel
extends BlockModel {
    private final List<ItemDisplayElement> modelElements = new ArrayList<ItemDisplayElement>();
    private final float viewRange;

    public BlockStateModel(class_2680 state, class_2338 pos, float viewRange) {
        List<BlockStateModelManager.ModelGetter> model = BlockStateModelManager.get(state);
        this.viewRange = viewRange;
        this.applyModel(model, pos);
    }

    public static BlockStateModel longRange(class_2680 state, class_2338 pos) {
        return new BlockStateModel(state, pos, 100.0f);
    }

    public static BlockStateModel midRange(class_2680 state, class_2338 pos) {
        return new BlockStateModel(state, pos, 3.0f);
    }

    public static BlockStateModel shortRange(class_2680 state, class_2338 pos) {
        return new BlockStateModel(state, pos, 1.1f);
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        super.notifyUpdate(updateType);
        if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
            this.applyModel(BlockStateModelManager.get(this.blockState()), this.blockPos());
            this.applyUpdates(this.blockState(), this.blockPos());
        }
    }

    protected void applyUpdates(class_2680 blockState, class_2338 pos) {
    }

    private void applyModel(List<BlockStateModelManager.ModelGetter> models, class_2338 pos) {
        class_5819 random = class_5819.method_43049((long)this.blockState().method_26190(pos));
        int i = 0;
        while (models.size() < this.modelElements.size()) {
            this.removeElement((VirtualElement)this.modelElements.removeLast());
        }
        while (i < models.size()) {
            ItemDisplayElement element;
            boolean newModel = false;
            if (this.modelElements.size() <= i) {
                element = ItemDisplayElementUtil.createSimple();
                element.setViewRange(this.viewRange);
                element.setTeleportDuration(0);
                element.setItemDisplayContext(class_811.field_4315);
                element.setYaw(180.0f);
                this.setupElement(element, i);
                this.setupElement(element, i, pos);
                newModel = true;
                this.modelElements.add(element);
            } else {
                element = this.modelElements.get(i);
            }
            BlockStateModelManager.ModelData model = models.get(i).getModel(random);
            element.setItem(model.stack());
            element.setLeftRotation(model.quaternionfc());
            if (newModel) {
                this.addElement((VirtualElement)element);
            } else {
                element.tick();
            }
            ++i;
        }
    }

    @Deprecated
    protected void setupElement(ItemDisplayElement element, int i) {
    }

    protected void setupElement(ItemDisplayElement element, int i, class_2338 pos) {
    }
}

