/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.virtualentity.emuvanilla2;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.emuvanilla2.model.EntityModel;
import eu.pb4.factorytools.api.virtualentity.emuvanilla2.model.LayerDefinition;
import eu.pb4.factorytools.api.virtualentity.emuvanilla2.model.Model;
import eu.pb4.factorytools.api.virtualentity.emuvanilla2.model.ModelPart;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelTransformation;
import java.util.IdentityHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_811;
import net.minecraft.class_9294;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record PolyModelInstance<T extends EntityModel<?>>(T model, LayerDefinition data, class_2960 texture, Function<ModelPart, @Nullable class_1799> modelParts, Function<ModelPart, @Nullable class_1799> damagedModelParts) {
    public static <T extends EntityModel<?>> PolyModelInstance<T> create(Function<ModelPart, T> modelCreator, LayerDefinition data, class_2960 texture) {
        EntityModel model = (EntityModel)modelCreator.apply(data.bakeRoot());
        return PolyModelInstance.of(model, data, texture);
    }

    public PolyModelInstance<T> withTexture(class_2960 texture) {
        return PolyModelInstance.of(this.model, this.data, texture);
    }

    private static <T extends EntityModel<?>> PolyModelInstance<T> of(T model, LayerDefinition data, class_2960 texture) {
        IdentityHashMap<ModelPart, class_1799> map = new IdentityHashMap<ModelPart, class_1799>();
        IdentityHashMap<ModelPart, class_1799> damagedMap = new IdentityHashMap<ModelPart, class_1799>();
        int id = 0;
        for (ModelPart part : model.allParts()) {
            if (part.isEmpty()) continue;
            class_1799 stack = ItemDisplayElementUtil.getModel(texture.method_48331("/part_" + id++));
            map.put(part, stack);
            stack = stack.method_7972();
            stack.method_57379(class_9334.field_49645, (Object)new class_9294(0xFF7E7E));
            damagedMap.put(part, stack);
        }
        return new PolyModelInstance<T>(model, data, texture, map::get, damagedMap::get);
    }

    public void generateAssets(BiConsumer<String, byte[]> writer, AtlasAsset.Builder atlas) {
        atlas.single(this.texture);
        int id = 0;
        for (ModelPart part : ((Model)this.model).allParts()) {
            if (part.isEmpty()) continue;
            class_2960 modelId = this.texture.method_48331("/part_" + id++);
            ModelAsset.Builder model = ModelAsset.builder();
            model.texture("txt", this.texture.toString());
            model.texture("particle", "#txt");
            part.forEachCuboid(cuboid -> {
                for (ModelPart.Polygon quad : cuboid.polygons) {
                    Vector3f pos;
                    Vector3f min = new Vector3f(Float.POSITIVE_INFINITY);
                    Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY);
                    ModelPart.Vertex v1 = quad.vertices()[0];
                    ModelPart.Vertex v2 = quad.vertices()[0];
                    for (ModelPart.Vertex vert : quad.vertices()) {
                        pos = new Vector3f(vert.x(), vert.y(), vert.z());
                        min.min((Vector3fc)pos);
                        max.max((Vector3fc)pos);
                    }
                    for (ModelPart.Vertex vert : quad.vertices()) {
                        pos = new Vector3f(vert.x(), vert.y(), vert.z());
                        if (min.equals((Object)pos)) {
                            v1 = vert;
                        }
                        if (!max.equals((Object)pos)) continue;
                        v2 = vert;
                    }
                    ModelElement.Builder b = ModelElement.builder((class_243)new class_243((double)min.x, (double)min.y, (double)min.z).method_1021(0.25).method_61889(8.0), (class_243)new class_243((double)max.x, (double)max.y, (double)max.z).method_1021(0.25).method_61889(8.0));
                    class_2350 dir = class_2350.method_62672((int)((int)quad.normal().x()), (int)((int)quad.normal().y()), (int)((int)quad.normal().z()), null);
                    if (dir.method_10171() == class_2350.class_2352.field_11060 == (dir.method_10166() == class_2350.class_2351.field_11051)) {
                        dir = dir.method_10153();
                    }
                    b.face(dir, v1.u() * 16.0f, v2.v() * 16.0f, v2.u() * 16.0f, v1.v() * 16.0f, "#txt", dir, 0, 0);
                    b.face(dir.method_10153(), v2.u() * 16.0f, v2.v() * 16.0f, v1.u() * 16.0f, v1.v() * 16.0f, "#txt", dir.method_10153(), 0, 0);
                    model.element(b.build());
                }
            });
            model.transformation(class_811.field_4319, new ModelTransformation(new class_243(0.0, 180.0, 0.0), class_243.field_1353, new class_243(4.0, 4.0, 4.0)));
            writer.accept(AssetPaths.model((class_2960)modelId) + ".json", model.build().toBytes());
        }
    }
}

