/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.block.model.generic;

import com.google.common.collect.Lists;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.factorytools.api.util.ResourceUtils;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateMultiPartDefinition;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import net.minecraft.class_6010;
import net.minecraft.class_6011;
import net.minecraft.class_6012;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockStateModelManager {
    public static final Map<String, Map<String, List<StateModelVariant>>> UV_LOCKED_MODELS = new HashMap<String, Map<String, List<StateModelVariant>>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockStateModelManager.class);
    private static final Map<class_2680, List<ModelGetter>> MAP = new HashMap<class_2680, List<ModelGetter>>();
    private static final Map<class_2680, class_2394> PARTICLE = new HashMap<class_2680, class_2394>();

    public static List<ModelGetter> get(class_2680 state) {
        return MAP.getOrDefault(state, List.of());
    }

    public static class_2394 getParticle(class_2680 state) {
        return PARTICLE.getOrDefault(state, (class_2394)class_2398.field_11231);
    }

    public static void addSolidBlock(class_2960 identifier, class_2248 block) {
        BlockStateModelManager.addBlock(identifier, block, ItemDisplayElementUtil::getSolidModel);
    }

    public static void addTransparentBlock(class_2960 identifier, class_2248 block) {
        BlockStateModelManager.addBlock(identifier, block, ItemDisplayElementUtil::getTransparentModel);
    }

    @Deprecated
    public static void addBlock(class_2960 identifier, class_2248 block) {
        BlockStateModelManager.addBlock(identifier, block, ItemDisplayElementUtil::getTransparentModel);
    }

    private static void addBlock(class_2960 identifier, class_2248 block, Function<class_2960, class_1799> modelGetter) {
        try {
            ArrayList<class_3545<Predicate<class_2680>, List<ModelData>>> list;
            class_5819 rand = class_5819.method_43049((long)123L);
            byte[] data = ResourceUtils.getJarData("assets/" + identifier.method_12836() + "/blockstates/" + identifier.method_12832() + ".json");
            DataResult decoded = BlockStateAsset.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8)));
            BlockStateAsset modelDef = (BlockStateAsset)((Pair)decoded.getOrThrow()).getFirst();
            if (modelDef.variants().isPresent()) {
                list = new ArrayList<class_3545<Predicate<class_2680>, List<ModelData>>>();
                BlockStateModelManager.parseVariants(block, (Map)modelDef.variants().get(), list, modelGetter);
                for (class_3545<class_2715, List<ModelData>> class_35452 : list) {
                    for (class_2680 state : block.method_9595().method_11662()) {
                        if (!((class_2715)class_35452.method_15442()).method_11760(state)) continue;
                        MAP.put(state, List.of(ModelGetter.of((List)class_35452.method_15441())));
                        if (((List)class_35452.method_15441()).isEmpty()) continue;
                        PARTICLE.put(state, (class_2394)new class_2392(class_2398.field_11218, ((ModelData)((List)class_35452.method_15441()).getFirst()).stack));
                    }
                }
            }
            if (modelDef.multipart().isPresent()) {
                list = new ArrayList();
                BlockStateModelManager.parseMultipart(block, (List)modelDef.multipart().get(), list, modelGetter);
                for (class_3545 class_35453 : list) {
                    for (class_2680 state : block.method_9595().method_11662()) {
                        if (!((Predicate)class_35453.method_15442()).test(state)) continue;
                        ArrayList<ModelGetter> objects = new ArrayList<ModelGetter>();
                        if (MAP.containsKey(state)) {
                            objects.addAll((Collection)MAP.get(state));
                        }
                        objects.add(ModelGetter.of((List)class_35453.method_15441()));
                        MAP.put(state, objects);
                        if (objects.isEmpty() || PARTICLE.containsKey(state)) continue;
                        PARTICLE.put(state, (class_2394)new class_2392(class_2398.field_11218, ((ModelGetter)objects.getFirst()).getModel((class_5819)rand).stack));
                    }
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to decode model for {}", (Object)identifier, (Object)e);
        }
    }

    private static void parseMultipart(class_2248 block, List<StateMultiPartDefinition> multiPartDefinition, ArrayList<class_3545<Predicate<class_2680>, List<ModelData>>> list, Function<class_2960, class_1799> modelGetter) {
        for (StateMultiPartDefinition part : multiPartDefinition) {
            Object preds;
            if (part.when().isEmpty()) {
                preds = class_2715.method_11758((class_2248)block);
            } else {
                StateMultiPartDefinition.Condition when = (StateMultiPartDefinition.Condition)part.when().get();
                preds = BlockStateModelManager.parsePredicate(block, when);
            }
            List<ModelData> modelData = BlockStateModelManager.parseBaseVariants(part.apply(), modelGetter);
            list.add((class_3545<Predicate<class_2680>, List<ModelData>>)new class_3545(preds, modelData));
        }
    }

    private static Predicate<class_2680> parsePredicate(class_2248 block, StateMultiPartDefinition.Condition when) {
        if (when instanceof StateMultiPartDefinition.KeyValueCondition) {
            StateMultiPartDefinition.KeyValueCondition keyVal = (StateMultiPartDefinition.KeyValueCondition)when;
            Predicate<class_2680> predicate = x -> true;
            for (Map.Entry pair : keyVal.tests().entrySet()) {
                class_2769 prop = block.method_9595().method_11663((String)pair.getKey());
                if (prop == null) continue;
                predicate = predicate.and(BlockStateModelManager.parseTerms(((StateMultiPartDefinition.KeyValueCondition.Terms)pair.getValue()).entries(), block, prop));
            }
            return predicate;
        }
        if (when instanceof StateMultiPartDefinition.CombinedCondition) {
            StateMultiPartDefinition.CombinedCondition combinedCondition = (StateMultiPartDefinition.CombinedCondition)when;
            Predicate[] predicates = (Predicate[])combinedCondition.terms().stream().map(x -> BlockStateModelManager.parsePredicate(block, x)).toArray(Predicate[]::new);
            return switch (combinedCondition.operation()) {
                default -> throw new MatchException(null, null);
                case StateMultiPartDefinition.CombinedCondition.Operation.OR -> class_156.method_61208((Predicate[])predicates);
                case StateMultiPartDefinition.CombinedCondition.Operation.AND -> class_156.method_61198((Predicate[])predicates);
            };
        }
        return x -> false;
    }

    private static <O, S extends class_2688<O, S>, T extends Comparable<T>> Predicate<S> parseTerms(List<StateMultiPartDefinition.KeyValueCondition.Term> entries, O owner, class_2769<T> property) {
        ArrayList valuesToMatch;
        boolean negate;
        Predicate allowedValueTest = class_156.method_56616((List)Lists.transform(entries, t -> BlockStateModelManager.parseTerm(owner, property, t)));
        ArrayList allowedValues = new ArrayList(property.method_11898());
        int allValuesCount = allowedValues.size();
        allowedValues.removeIf(allowedValueTest.negate());
        int allowedValuesCount = allowedValues.size();
        if (allowedValuesCount == 0) {
            return blockState -> false;
        }
        int rejectedValuesCount = allValuesCount - allowedValuesCount;
        if (rejectedValuesCount == 0) {
            return blockState -> true;
        }
        if (allowedValuesCount <= rejectedValuesCount) {
            negate = false;
            valuesToMatch = allowedValues;
        } else {
            negate = true;
            ArrayList rejectedValues = new ArrayList(property.method_11898());
            rejectedValues.removeIf(allowedValueTest);
            valuesToMatch = rejectedValues;
        }
        if (valuesToMatch.size() == 1) {
            Comparable expectedValue = (Comparable)valuesToMatch.getFirst();
            return state -> {
                Comparable value = state.method_11654(property);
                return expectedValue.equals(value) ^ negate;
            };
        }
        return state -> {
            Comparable value = state.method_11654(property);
            return valuesToMatch.contains(value) ^ negate;
        };
    }

    private static <T extends Comparable<T>> T getValueOrThrow(Object owner, class_2769<T> property, String input) {
        Optional value = property.method_11900(input);
        if (value.isEmpty()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Unknown value '%s' for property '%s' on '%s'", input, property, owner));
        }
        return (T)((Comparable)value.get());
    }

    private static <T extends Comparable<T>> Predicate<T> parseTerm(Object owner, class_2769<T> property, StateMultiPartDefinition.KeyValueCondition.Term term) {
        Object parsedValue = BlockStateModelManager.getValueOrThrow(owner, property, term.value());
        return term.negated() ? value -> !value.equals(parsedValue) : value -> value.equals(parsedValue);
    }

    private static void parseVariants(class_2248 block, Map<String, List<StateModelVariant>> modelDef, ArrayList<class_3545<class_2715, List<ModelData>>> list, Function<class_2960, class_1799> modelGetter) {
        BlockStateModelManager.parseVariants(block, modelDef, (a, b) -> {
            List<ModelData> modelData = BlockStateModelManager.parseBaseVariants(b, modelGetter);
            list.add(new class_3545(a, modelData));
        });
    }

    public static void parseVariants(class_2248 block, Map<String, List<StateModelVariant>> modelDef, BiConsumer<class_2715, List<StateModelVariant>> consumer) {
        block0: for (Map.Entry<String, List<StateModelVariant>> pair : modelDef.entrySet()) {
            String[] stateMap = pair.getKey().split(",");
            class_2715 predicate = class_2715.method_11758((class_2248)block);
            for (String statePair : stateMap) {
                if (statePair.isEmpty()) continue;
                String[] split = statePair.split("=", 2);
                class_2769 prop = block.method_9595().method_11663(split[0]);
                if (prop == null) continue block0;
                predicate.method_11762(prop, x -> prop.method_11901((Comparable)x).equals(split[1]));
            }
            consumer.accept(predicate, pair.getValue());
        }
    }

    private static List<ModelData> parseBaseVariants(List<StateModelVariant> value, Function<class_2960, class_1799> modelGetter) {
        ArrayList<ModelData> modelData = new ArrayList<ModelData>();
        for (StateModelVariant v : value) {
            if (v.uvlock()) {
                class_2960 modelId = v.model().method_48331("_uvlock_" + v.x() + "_" + v.y());
                class_1799 stack = modelGetter.apply(modelId);
                modelData.add(new ModelData(stack, (Quaternionfc)new Quaternionf(), v.weigth()));
                UV_LOCKED_MODELS.computeIfAbsent(v.model().method_12836(), x -> new HashMap()).computeIfAbsent(v.model().method_12832(), x -> new ArrayList()).add(v);
                continue;
            }
            class_1799 stack = modelGetter.apply(v.model());
            modelData.add(new ModelData(stack, (Quaternionfc)new Quaternionf().rotateY((float)(-Math.PI) / 180 * (float)v.y()).rotateX((float)Math.PI / 180 * (float)v.x()), v.weigth()));
        }
        return modelData;
    }

    public static interface ModelGetter {
        public static ModelGetter of(List<ModelData> data) {
            if (data.size() == 1) {
                return new SingleGetter(data.get(0));
            }
            return WeightedGetter.create(data);
        }

        public ModelData getModel(class_5819 var1);
    }

    public record ModelData(class_1799 stack, Quaternionfc quaternionfc, int weight) {
    }

    private record WeightedGetter(class_6012<ModelData> data, int weightedSum) implements ModelGetter
    {
        public static ModelGetter create(List<ModelData> data) {
            ArrayList<class_6010> list = new ArrayList<class_6010>();
            for (ModelData d : data) {
                list.add(new class_6010((Object)d, d.weight));
            }
            int x = class_6011.method_34984(list, class_6010::comp_2543);
            return new WeightedGetter((class_6012<ModelData>)class_6012.method_34988(list), x);
        }

        @Override
        public ModelData getModel(class_5819 random) {
            return (ModelData)this.data.method_66216(random);
        }
    }

    private record SingleGetter(ModelData data) implements ModelGetter
    {
        @Override
        public ModelData getModel(class_5819 random) {
            return this.data;
        }
    }
}

