/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.factorytools.api.virtualentity;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.tracker.DataTrackerLike;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.SimpleDataTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2739;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class LodItemDisplayElement
extends ItemDisplayElement {
    protected static final Set<class_2940<?>> DEFAULT_LOD = Set.of(DisplayTrackedData.START_INTERPOLATION, DisplayTrackedData.INTERPOLATION_DURATION, DisplayTrackedData.TRANSLATION, DisplayTrackedData.SCALE, DisplayTrackedData.LEFT_ROTATION, DisplayTrackedData.RIGHT_ROTATION);
    public static boolean isEnabled = true;
    public static boolean isDisabled = false;
    public final DataTrackerLike nearTracker = new SimpleDataTracker(this.getEntityType());
    public final DataTrackerLike mediumTracker = new SimpleDataTracker(this.getEntityType());
    public final DataTrackerLike mainTracker = new SimpleDataTracker(this.getEntityType());
    protected Set<class_2940<?>> lodTracked = DEFAULT_LOD;
    private int updateTick = 0;
    protected double nearDistanceSquared = 2500.0;
    protected float farDistanceSquared = 8100.0f;

    public LodItemDisplayElement(class_1799 stack) {
        this.getDataTracker().set(DisplayTrackedData.Item.ITEM, (Object)stack);
    }

    public LodItemDisplayElement() {
    }

    @Deprecated
    public static LodItemDisplayElement createSimple(class_1792 model) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getModel(model));
    }

    @Deprecated
    public static LodItemDisplayElement createSimple(class_2960 model) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getModel(model));
    }

    public static LodItemDisplayElement createSolid(class_1792 model) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getSolidModel(model));
    }

    public static LodItemDisplayElement createSolid(class_2960 model) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getSolidModel(model));
    }

    public static LodItemDisplayElement createTransparent(class_1792 model) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getTransparentModel(model));
    }

    public static LodItemDisplayElement createTransparent(class_2960 model) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getTransparentModel(model));
    }

    public static LodItemDisplayElement createSimple(class_1799 model) {
        LodItemDisplayElement element = LodItemDisplayElement.createSimple();
        element.setItem(model);
        return element;
    }

    public static LodItemDisplayElement createSimple(class_1799 model, int updateRate, float qualityMultiplier, float farQualityDistanceMultiplier) {
        LodItemDisplayElement element = LodItemDisplayElement.createSimple(model, updateRate);
        element.nearDistanceSquared = 2500.0f * qualityMultiplier * qualityMultiplier;
        element.farDistanceSquared = 8100.0f * farQualityDistanceMultiplier * farQualityDistanceMultiplier;
        return element;
    }

    public static LodItemDisplayElement createSimple(class_1799 model, int updateRate, float qualityMultiplier) {
        LodItemDisplayElement element = LodItemDisplayElement.createSimple(model, updateRate);
        element.nearDistanceSquared = 2500.0f * qualityMultiplier * qualityMultiplier;
        return element;
    }

    @Deprecated
    public static LodItemDisplayElement createSimple(class_1792 model, int updateRate) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getModel(model), updateRate);
    }

    @Deprecated
    public static LodItemDisplayElement createSimple(class_2960 model, int updateRate) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getModel(model), updateRate);
    }

    public static LodItemDisplayElement createSolid(class_1792 model, int updateRate) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getSolidModel(model), updateRate);
    }

    public static LodItemDisplayElement createSolid(class_2960 model, int updateRate) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getSolidModel(model), updateRate);
    }

    public static LodItemDisplayElement createTransparent(class_1792 model, int updateRate) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getTransparentModel(model), updateRate);
    }

    public static LodItemDisplayElement createTransparent(class_2960 model, int updateRate) {
        return LodItemDisplayElement.createSimple(ItemDisplayElementUtil.getTransparentModel(model), updateRate);
    }

    public static LodItemDisplayElement createSimple(class_1799 model, int updateRate) {
        LodItemDisplayElement element = LodItemDisplayElement.createSimple(model);
        element.setInterpolationDuration(updateRate);
        return element;
    }

    public static LodItemDisplayElement createSimple() {
        LodItemDisplayElement element = new LodItemDisplayElement();
        element.setDisplaySize(2.0f, 2.0f);
        element.setViewRange(0.8f);
        element.setItemDisplayContext(class_811.field_4319);
        element.setTeleportDuration(1);
        element.setInvisible(true);
        return element;
    }

    public void addLodData(class_2940<?> data) {
        if (this.lodTracked == DEFAULT_LOD) {
            this.lodTracked = new HashSet(this.lodTracked);
        }
        this.lodTracked.add(data);
    }

    protected DataTrackerLike createDataTracker() {
        return new DataTrackerLike(){

            @Nullable
            public <T> T get(class_2940<T> data) {
                return (T)(LodItemDisplayElement.this.lodTracked.contains(data) ? LodItemDisplayElement.this.nearTracker.get(data) : LodItemDisplayElement.this.mainTracker.get(data));
            }

            public <T> void set(class_2940<T> key, T value, boolean forceDirty) {
                if (LodItemDisplayElement.this.lodTracked.contains(key)) {
                    LodItemDisplayElement.this.nearTracker.set(key, value, forceDirty);
                    if (key != DisplayTrackedData.START_INTERPOLATION) {
                        LodItemDisplayElement.this.mediumTracker.set(key, value, forceDirty);
                    }
                } else {
                    LodItemDisplayElement.this.mainTracker.set(key, value, forceDirty);
                }
            }

            public <T> void setDirty(class_2940<T> key, boolean isDirty) {
                this.set(key, this.get(key), isDirty);
            }

            public boolean isDirty() {
                return LodItemDisplayElement.this.nearTracker.isDirty() || LodItemDisplayElement.this.mainTracker.isDirty();
            }

            public boolean isDirty(class_2940<?> key) {
                return LodItemDisplayElement.this.nearTracker.isDirty(key) || LodItemDisplayElement.this.mainTracker.isDirty(key);
            }

            @Nullable
            public List<class_2945.class_7834<?>> getDirtyEntries() {
                return LodItemDisplayElement.this.mainTracker.getDirtyEntries();
            }

            @Nullable
            public List<class_2945.class_7834<?>> getChangedEntries() {
                List b;
                ArrayList x = new ArrayList();
                List a = LodItemDisplayElement.this.nearTracker.getChangedEntries();
                if (a != null) {
                    x.addAll(a);
                }
                if ((b = LodItemDisplayElement.this.mainTracker.getChangedEntries()) != null) {
                    x.addAll(b);
                }
                return x.isEmpty() ? null : x;
            }
        };
    }

    protected void sendTrackerUpdates() {
        if (isDisabled) {
            if (this.nearTracker.isDirty()) {
                this.getHolder().sendPacket((class_2596)new class_2739(this.getEntityId(), this.nearTracker.getDirtyEntries()));
            }
            if (this.mainTracker.isDirty()) {
                this.getHolder().sendPacket((class_2596)new class_2739(this.getEntityId(), this.mainTracker.getDirtyEntries()));
            }
        } else {
            class_2739 nearPacket = null;
            class_2739 mediumPacket = null;
            if (this.mainTracker.isDirty()) {
                this.getHolder().sendPacket((class_2596)new class_2739(this.getEntityId(), this.mainTracker.getDirtyEntries()));
            }
            if (this.nearTracker.isDirty()) {
                nearPacket = new class_2739(this.getEntityId(), this.nearTracker.getDirtyEntries());
            }
            if (this.mediumTracker.isDirty() && this.updateTick++ % 10 == 0) {
                mediumPacket = new class_2739(this.getEntityId(), this.mediumTracker.getDirtyEntries());
            }
            if (nearPacket == null && mediumPacket == null) {
                return;
            }
            for (class_3244 player : this.getHolder().getWatchingPlayers()) {
                double d = this.getSquaredDistance(player);
                if (d < this.nearDistanceSquared) {
                    if (nearPacket == null) continue;
                    player.method_14364((class_2596)nearPacket);
                    continue;
                }
                if (!(d < (double)this.farDistanceSquared) || mediumPacket == null) continue;
                player.method_14364((class_2596)mediumPacket);
            }
        }
    }

    protected double getSquaredDistance(class_3244 player) {
        return Objects.requireNonNull(this.getHolder()).getPos().method_1025(player.field_14140.method_73189());
    }
}

