package dev.emi.trinkets;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class TrinketModifiers {

	//internalizes getTrinket and slotIdentifier, both which typically are generated just before the modifiers call anyway
	public static Multimap<class_6880<class_1320>, class_1322> get(class_1799 stack, SlotReference slot, class_1309 entity){
		Multimap<class_6880<class_1320>, class_1322> map = TrinketsApi.getTrinket(stack.method_7909()).getModifiers(stack, slot, entity, SlotAttributes.getIdentifier(slot));
		if (stack.method_57826(TrinketsAttributeModifiersComponent.TYPE)) {
			for (TrinketsAttributeModifiersComponent. Entry entry : stack.method_58695(TrinketsAttributeModifiersComponent.TYPE, TrinketsAttributeModifiersComponent.DEFAULT).modifiers()) {
				map.put(entry.attribute(), entry.modifier());
			}
		}
		return map;
	}

	//overload if a custom method for retrieving the trinket is used. Also exposes the slotIdentifier if custom on that is needed
	public static Multimap<class_6880<class_1320>, class_1322> get(Trinket trinket, class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier){
		Multimap<class_6880<class_1320>, class_1322> map = trinket.getModifiers(stack, slot, entity, slotIdentifier);
		if (stack.method_57826(TrinketsAttributeModifiersComponent.TYPE)) {
			for (TrinketsAttributeModifiersComponent. Entry entry : stack.method_58695(TrinketsAttributeModifiersComponent.TYPE, TrinketsAttributeModifiersComponent.DEFAULT).modifiers()) {
				if (entry.slot().isEmpty() || entry.slot().get().equals(slot.inventory().getSlotType().getId())) {
					map.put(entry.attribute(), entry.modifier());
				}
			}
		}
		return map;
	}
}