package dev.emi.trinkets;

import static com.mojang.brigadier.arguments.IntegerArgumentType.integer;
import static com.mojang.brigadier.arguments.StringArgumentType.string;
import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import dev.emi.trinkets.api.*;
import dev.emi.trinkets.payload.BreakPayload;
import dev.emi.trinkets.payload.SyncInventoryPayload;
import dev.emi.trinkets.payload.SyncSlotsPayload;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;

import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.data.SlotLoader;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;

import java.util.Map;

public class TrinketsMain implements ModInitializer, EntityComponentInitializer {

	public static final String MOD_ID = "trinkets";
	public static final Logger LOGGER = LogManager.getLogger();

	@Override
	public void onInitialize() {
		ResourceManagerHelper resourceManagerHelper = ResourceManagerHelper.get(class_3264.field_14190);
		resourceManagerHelper.registerReloadListener(SlotLoader.INSTANCE);
		resourceManagerHelper.registerReloadListener(EntitySlotLoader.SERVER);
		ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success)
				-> EntitySlotLoader.SERVER.sync(server.method_3760().method_14571()));
		UseItemCallback.EVENT.register((player, world, hand) -> {
			class_1799 stack = player.method_5998(hand);
			Trinket trinket = TrinketsApi.getTrinket(stack.method_7909());
			if (trinket.canEquipFromUse(stack, player)) {
				if (TrinketItem.equipItem(player, stack)) {
					return class_1269.field_5812;
				}
			}
			return class_1269.field_5811;
		});
		class_2378.method_10230(class_7923.field_49658, class_2960.method_60655(MOD_ID, "attribute_modifiers"), TrinketsAttributeModifiersComponent.TYPE);
		PayloadTypeRegistry.playS2C().register(TrinketsNetwork.BREAK, BreakPayload.CODEC);
		PayloadTypeRegistry.playS2C().register(TrinketsNetwork.SYNC_INVENTORY, SyncInventoryPayload.CODEC);
		PayloadTypeRegistry.playS2C().register(TrinketsNetwork.SYNC_SLOTS, SyncSlotsPayload.CODEC);
		CommandRegistrationCallback.EVENT.register((dispatcher, registry, env) ->
			dispatcher.register(method_9247("trinkets")
				.requires(source -> source.method_9259(2))
				.then(
					method_9247("set")
					.then(
						method_9244("group", string())
						.then(
							method_9244("slot", string())
							.then(
								method_9244("offset", integer(0))
								.then(
									method_9244("stack", class_2287.method_9776(registry))
									.executes(context -> {
										try {
										return trinketsCommand(context, 1);

										} catch (Exception e) {
											e.printStackTrace();
											return -1;
										}
									})
									.then(
										method_9244("count", integer(1))
										.executes(context -> {
											int amount = context.getArgument("amount", Integer.class);
											return trinketsCommand(context, amount);
										})
									)
								)
							)
						)
					)
				)
				.then(
					method_9247("clear")
					.executes(context -> {
						try {
							return clearCommand(context);
						} catch (Exception e){
							e.printStackTrace();
							return -1;
						}
					})
				)
			));
	}

	private static int clearCommand(CommandContext<class_2168> context){
		class_3222 player = context.getSource().method_44023();
		if (player != null) {
			TrinketComponent comp = TrinketsApi.getTrinketComponent(player).get();
			for (Map.Entry<String, Map<String, TrinketInventory>> entry : comp.getInventory().entrySet()){
				for (TrinketInventory inv : entry.getValue().values()){
					inv.method_5448();
				}
			}
		}
		return 1;
	}

	private static int trinketsCommand(CommandContext<class_2168> context, int amount) {
		try {
			String group = context.getArgument("group", String.class);
			String slot = context.getArgument("slot", String.class);
			int offset = context.getArgument("offset", Integer.class);
			class_2290 stack = context.getArgument("stack", class_2290.class);
			class_3222 player = context.getSource().method_44023();
			if (player != null) {
				TrinketComponent comp = TrinketsApi.getTrinketComponent(player).get();
				SlotGroup slotGroup = comp.getGroups().getOrDefault(group, null);
				if (slotGroup != null) {
					SlotType slotType = slotGroup.getSlots().getOrDefault(slot, null);
					if (slotType != null) {
						if (offset >= 0 && offset < slotType.getAmount()) {
							comp.getInventory().get(group).get(slot).method_5447(offset, stack.method_9781(amount, true));
							return Command.SINGLE_SUCCESS;
						} else {
							context.getSource().method_9213(class_2561.method_43470(offset + " offset does not exist for slot"));
						}
					} else {
						context.getSource().method_9213(class_2561.method_43470(slot + " does not exist"));
					}
				} else {
					context.getSource().method_9213(class_2561.method_43470(group + " does not exist"));
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return -1;
	}

	@Override
	public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
		registry.registerFor(class_1309.class, TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new);
		registry.registerForPlayers(TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
	}
}