package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;

public final class SlotGroup {

	private final String name;
	private final int slotId;
	private final int order;
	private final Map<String, SlotType> slots;

	private SlotGroup(Builder builder) {
		this.name = builder.name;
		this.slots = builder.slots;
		this.slotId = builder.slotId;
		this.order = builder.order;
	}

	public int getSlotId() {
		return slotId;
	}

	public int getOrder() {
		return order;
	}

	public String getName() {
		return name;
	}

	public Map<String, SlotType> getSlots() {
		return ImmutableMap.copyOf(slots);
	}

	public void write(class_2487 data) {
		class_2487 tag = new class_2487();
		tag.method_10582("Name", name);
		tag.method_10569("SlotId", slotId);
		tag.method_10569("Order", order);
		class_2487 typesTag = new class_2487();

		slots.forEach((id, slot) -> {
			class_2487 typeTag = new class_2487();
			slot.write(typeTag);
			typesTag.method_10566(id, typeTag);
		});
		tag.method_10566("SlotTypes", typesTag);
		data.method_10566("GroupData", tag);
	}

	public static SlotGroup read(class_2487 data) {
		class_2487 groupData = data.method_68568("GroupData");
		String name = groupData.method_68564("Name", "");
		int slotId = groupData.method_68083("SlotId", 0);
		int order = groupData.method_68083("Order", 0);
		class_2487 typesTag = groupData.method_68568("SlotTypes");
		Builder builder = new Builder(name, slotId, order);

		for (String id : typesTag.method_10541()) {
			class_2487 tag = (class_2487) typesTag.method_10580(id);

			if (tag != null) {
				builder.addSlot(id, SlotType.read(tag));
			}
		}
		return builder.build();
	}

	public static class Builder {

		private final String name;
		private final int slotId;
		private final int order;
		private final Map<String, SlotType> slots = new HashMap<>();

		public Builder(String name, int slotId, int order) {
			this.name = name;
			this.slotId = slotId;
			this.order = order;
		}

		public Builder addSlot(String name, SlotType slot) {
			this.slots.put(name, slot);
			return this;
		}

		public SlotGroup build() {
			return new SlotGroup(this);
		}
	}
}
