package dev.emi.trinkets.api;

import dev.emi.trinkets.TrinketSlot;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

/**
 * A convenient base class for trinket items that automatically registers itself and
 */
public class TrinketItem extends class_1792 implements Trinket {

	public TrinketItem(class_1792.class_1793 settings) {
		super(settings);
		TrinketsApi.registerTrinket(this, this);
	}

	@Override
	public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
		class_1799 stack = user.method_5998(hand);
		if (equipItem(user, stack)) {
			return class_1269.field_5812;
		}
		return super.method_7836(world, user, hand);
	}

	public static boolean equipItem(class_1657 user, class_1799 stack) {
		return equipItem((class_1309) user, stack);
	}

	public static boolean equipItem(class_1309 user, class_1799 stack) {
		Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent(user);
		if (optional.isPresent()) {
			TrinketComponent comp = optional.get();
			for (Map<String, TrinketInventory> group : comp.getInventory().values()) {
				for (TrinketInventory inv : group.values()) {
					for (int i = 0; i < inv.method_5439(); i++) {
						if (inv.method_5438(i).method_7960()) {
							SlotReference ref = new SlotReference(inv, i);
							if (TrinketSlot.canInsert(stack, ref, user)) {
								class_1799 newStack = stack.method_7972();
								inv.method_5447(i, newStack);
								Trinket trinket = TrinketsApi.getTrinket(stack.method_7909());
								class_6880<class_3414> soundEvent = trinket.getEquipSound(stack, ref, user);
								if (!stack.method_7960() && soundEvent != null) {
								   user.method_32876(class_5712.field_28739);
								   user.method_5783(soundEvent.comp_349(), 1.0F, 1.0F);
								}
								stack.method_7939(0);
								return true;
							}
						}
					}
				}
			}
		}
		return false;
	}
}