package dev.emi.trinkets.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.TrinketInventory;
import net.minecraft.class_2724;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Copies slot EAMs to players client-side when changing dimensions
 *
 * @author C4
 */
@Mixin(class_634.class)
public class ClientPlayNetworkHandlerMixin {

    @Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;setId(I)V"), method = "onPlayerRespawn")
    private void onPlayerRespawn(class_2724 packet, CallbackInfo info, @Local(ordinal = 0) class_746 clientPlayerEntity, @Local(ordinal = 1) class_746 clientPlayerEntity2)  {
        if (packet.method_48016(class_2724.field_41730)) {
            TrinketInventory.copyFrom(clientPlayerEntity, clientPlayerEntity2);
            ((TrinketPlayerScreenHandler) clientPlayerEntity2.field_7498).trinkets$updateTrinketSlots(false);
        }
    }
}
