package dev.emi.trinkets.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import dev.emi.trinkets.CreativeTrinketScreen;
import dev.emi.trinkets.CreativeTrinketSlot;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.SurvivalTrinketSlot;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.class_10799;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_481.class_483;
import net.minecraft.class_768;

/**
 * Delegates drawing and slot group selection logic
 * 
 * @author Emi
 */
@Mixin(class_481.class)
public abstract class CreativeInventoryScreenMixin extends class_465<class_483> implements TrinketScreen, CreativeTrinketScreen {
	@Unique
	private static final class_2960 SLOT_HIGHLIGHT_FRONT_TEXTURE = class_2960.method_60656("container/slot_highlight_front");
	@Shadow
	private static class_1761 selectedTab;
	@Shadow
	protected abstract void setSelectedTab(class_1761 group);

	private CreativeInventoryScreenMixin() {
		super(null, null, null);
	}

	@Redirect(at = @At(value = "INVOKE", target = "net/minecraft/util/collection/DefaultedList.size()I"), method = "setSelectedTab")
	private int size(class_2371<class_1799> list) {
		return 46;
	}

	@Inject(at = @At("HEAD"), method = "setSelectedTab")
	private void setSelectedTab(class_1761 g, CallbackInfo info) {
		if (g.method_47312() != class_1761.class_7916.field_41053) {
			TrinketScreenManager.removeSelections();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "net/minecraft/screen/slot/Slot.<init>(Lnet/minecraft/inventory/Inventory;III)V"), method = "setSelectedTab")
	private void addCreativeTrinketSlots(class_1761 g, CallbackInfo info) {
		TrinketPlayerScreenHandler handler = trinkets$getHandler();
		for (int i = handler.trinkets$getTrinketSlotStart(); i < handler.trinkets$getTrinketSlotEnd(); i++) {
			class_1735 slot = this.field_22787.field_1724.field_7498.field_7761.get(i);
			if (slot instanceof SurvivalTrinketSlot ts) {
				SlotGroup group = TrinketsApi.getPlayerSlots(this.field_22787.field_1724).get(ts.getType().getGroup());
				class_768 rect = trinkets$getGroupRect(group);
				Point pos = trinkets$getHandler().trinkets$getGroupPos(group);
				if (pos == null) {
					return;
				}
				int xOff = rect.method_3321() + 1 - pos.x();
				int yOff = rect.method_3322() + 1 - pos.y();
				((class_483) this.field_2797).field_7761.add(new CreativeTrinketSlot(ts, ts.method_34266(), ts.field_7873 + xOff, ts.field_7872 + yOff));
			}
		}
	}

	@Inject(at = @At("HEAD"), method = "init")
	private void init(CallbackInfo info) {
		TrinketScreenManager.init(this);
	}

	@Inject(at = @At("HEAD"), method = "removed")
	private void removed(CallbackInfo info) {
		TrinketScreenManager.removeSelections();
	}

	@Inject(at = @At("TAIL"), method = "handledScreenTick")
	private void tick(CallbackInfo info) {
		TrinketScreenManager.tick();
	}

	@Inject(at = @At("HEAD"), method = "render")
	private void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo info) {
		if (selectedTab.method_47312() == class_1761.class_7916.field_41053) {
			TrinketScreenManager.update(mouseX, mouseY);
		}
	}

	@Inject(at = @At("RETURN"), method = "drawBackground")
	private void drawBackground(class_332 context, float delta, int mouseX, int mouseY, CallbackInfo info) {
		if (selectedTab.method_47312() == class_1761.class_7916.field_41053) {
			TrinketScreenManager.drawExtraGroups(context);
		}
	}

	@Override
	public void trinkets$renderCreative(class_332 context, int mouseX, int mouseY, float deltaTicks) {
		if (selectedTab.method_47312() == class_1761.class_7916.field_41053) {
			context.method_51448().pushMatrix();
			context.method_51448().translate(this.field_2776, this.field_2800);
			TrinketScreenManager.drawActiveGroup(context);

			for (class_1735 slot : this.field_2797.field_7761) {
				if (slot instanceof TrinketSlot trinketSlot && trinketSlot.renderAfterRegularSlots() && slot.method_7682()) {
					this.method_2385(context, slot);
					if (slot == this.field_2787 && slot.method_51306()) {
						context.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_TEXTURE, this.field_2787.field_7873 - 4, this.field_2787.field_7872 - 4, 24, 24);
					}
				}
			}
			context.method_51448().popMatrix();
		}
	}

	@Inject(at = @At("HEAD"), method = "isClickOutsideBounds", cancellable = true)
	private void isClickOutsideBounds(double mouseX, double mouseY, int left, int top, CallbackInfoReturnable<Boolean> info) {
		if (selectedTab.method_47312() == class_1761.class_7916.field_41053 && TrinketScreenManager.isClickInsideTrinketBounds(mouseX, mouseY)) {
			info.setReturnValue(false);
		}
	}

	@Inject(at = @At("HEAD"), method = "isClickInTab", cancellable = true)
	private void isClickInTab(class_1761 group, double mouseX, double mouseY, CallbackInfoReturnable<Boolean> info) {
		if (TrinketsClient.activeGroup != null) {
			info.setReturnValue(false);
		}
	}
	
	@Inject(at = @At("HEAD"), method = "renderTabTooltipIfHovered", cancellable = true)
	private void renderTabTooltipIfHovered(class_332 context, class_1761 group, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> info) {
		if (TrinketsClient.activeGroup != null) {
			info.setReturnValue(false);
		}
	}

	@Override
	public TrinketPlayerScreenHandler trinkets$getHandler() {
		return (TrinketPlayerScreenHandler) this.field_22787.field_1724.field_7498;
	}

	@Override
	public class_768 trinkets$getGroupRect(SlotGroup group) {
		int groupNum = trinkets$getHandler().trinkets$getGroupNum(group);
		if (groupNum <= 3) {
			// Look what else do you want me to do
			return switch (groupNum) {
				case 1 -> new class_768(15, 19, 17, 17);
				case 2 -> new class_768(126, 19, 17, 17);
				case 3 -> new class_768(145, 19, 17, 17);
				case -5 -> new class_768(53, 5, 17, 17);
				case -6 -> new class_768(53, 32, 17, 17);
				case -7 -> new class_768(107, 5, 17, 17);
				case -8 -> new class_768(107, 32, 17, 17);
				case -45 -> new class_768(34, 19, 17, 17);
				default -> new class_768(0, 0, 0, 0);
			};
		}
		Point pos = trinkets$getHandler().trinkets$getGroupPos(group);
		if (pos != null) {
			return new class_768(pos.x() - 1, pos.y() - 1, 17, 17);
		}
		return new class_768(0, 0, 0, 0);
	}

	@Override
	public class_1735 trinkets$getFocusedSlot() {
		return this.field_2787;
	}

	@Override
	public int trinkets$getX() {
		return this.field_2776;
	}

	@Override
	public int trinkets$getY() {
		return this.field_2800;
	}

	@Override
	public boolean trinkets$isRecipeBookOpen() {
		return false;
	}

	@Override
	public void trinkets$updateTrinketSlots() {
		setSelectedTab(selectedTab);
	}
}
