package dev.emi.trinkets.mixin;


import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.emi.trinkets.CreativeTrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.mixin.accessor.CreativeSlotAccessor;
import net.minecraft.class_10799;
import net.minecraft.class_1735;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481.class_484;
import net.minecraft.class_490;

/**
 * Draws trinket slot backs, adjusts z location of draw calls, and makes non-trinket slots un-interactable while a trinket slot group is focused
 * 
 * @author Emi
 */
@Mixin(class_465.class)
public abstract class HandledScreenMixin extends class_437 {
	@Shadow @Nullable protected class_1735 focusedSlot;
	@Shadow @Final private static class_2960 SLOT_HIGHLIGHT_BACK_TEXTURE;
	@Unique
	private static final class_2960 MORE_SLOTS = class_2960.method_60655("trinkets", "textures/gui/more_slots.png");
	@Unique
	private static final class_2960 BLANK_BACK = class_2960.method_60655("trinkets", "textures/gui/blank_back.png");

	private HandledScreenMixin() {
		super(null);
	}

	@Inject(at = @At("HEAD"), method = "removed")
	private void removed(CallbackInfo info) {
		if ((Object)this instanceof class_490) {
			TrinketScreenManager.removeSelections();
		}
	}

	@WrapWithCondition(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlot(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/screen/slot/Slot;)V"),
			method = "drawSlots")
	private boolean preventDrawingSlots(class_465 instance, class_332 context, class_1735 slot) {
		return !(slot instanceof TrinketSlot trinketSlot) || !trinketSlot.renderAfterRegularSlots();
	}

	@Inject(at = @At("HEAD"), method = "drawSlot")
	private void drawSlotBackground(class_332 context, class_1735 slot, CallbackInfo info) {
		if (slot instanceof TrinketSlot ts) {
			assert this.field_22787 != null;
			class_2960 slotTextureId = ts.getBackgroundIdentifier();

			if (!slot.method_7677().method_7960() || slotTextureId == null) {
				slotTextureId = BLANK_BACK;
			}

			if (ts.isTrinketFocused()) {
				context.method_25290(class_10799.field_56883, slotTextureId, slot.field_7873, slot.field_7872, 0, 0, 16, 16, 16, 16);
				if (this.focusedSlot == slot && this.focusedSlot.method_51306()) {
					context.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_TEXTURE, this.focusedSlot.field_7873 - 4, this.focusedSlot.field_7872 - 4, 24, 24);
				}
			} else {
				context.method_25290(class_10799.field_56883, slotTextureId, slot.field_7873, slot.field_7872, 0, 0, 16, 16, 16, 16);
				context.method_25290(class_10799.field_56883, MORE_SLOTS, slot.field_7873 - 1, slot.field_7872 - 1, 4, 4, 18, 18, 256, 256);
			}
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;renderMain(Lnet/minecraft/client/gui/DrawContext;IIF)V", shift = At.Shift.AFTER), method = "render")
	private void renderCreativeSlots(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
		if (this instanceof CreativeTrinketScreen screen) {
			screen.trinkets$renderCreative(context, mouseX, mouseY, deltaTicks);
		}
	}

	@Inject(at = @At("HEAD"), method = "isPointOverSlot", cancellable = true)
	private void isPointOverSlot(class_1735 slot, double pointX, double pointY, CallbackInfoReturnable<Boolean> info) {
		if (TrinketsClient.activeGroup != null) {
			if (slot instanceof TrinketSlot ts) {
				if (!ts.isTrinketFocused()) {
					info.setReturnValue(false);
				}
			} else {
				if (slot instanceof class_484 cs) {
					if (((CreativeSlotAccessor) cs).getSlot().field_7874 != TrinketsClient.activeGroup.getSlotId()) {
						info.setReturnValue(false);
					}
				} else if (slot.field_7874 != TrinketsClient.activeGroup.getSlotId()) {
					info.setReturnValue(false);
				}
			}
		}
	}
}
