package dev.emi.trinkets;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_583;

public class TrinketFeatureRenderer<T extends class_10042, M extends class_583<T>> extends class_3887<T, M> {

	public TrinketFeatureRenderer(class_3883<T, M> context) {
		super(context);
	}

	public static void update(class_1309 livingEntity, class_10042 entityState, float tickDelta, TrinketEntityRenderState state) {
		Optional<TrinketComponent> component = TrinketsApi.getTrinketComponent(livingEntity);
		if (component.isEmpty()) {
			state.trinkets$setState(List.of());
		} else {
			List<class_3545<class_1799, SlotReference>> items = new ArrayList<>();
			component.get().forEach((slotReference, stack) -> items.add(new class_3545<>(stack, slotReference)));
			state.trinkets$setState(items);
		}
	}

	@Override
	public void render(class_4587 matrices, class_11659 queue, int light, T state, float limbAngle, float limbDistance) {
		((TrinketEntityRenderState) state).trinkets$getState().forEach(pair -> {
			TrinketRendererRegistry.getRenderer(pair.method_15442().method_7909()).ifPresent(renderer -> {
				matrices.method_22903();
				renderer.render(pair.method_15442(), pair.method_15441(), this.method_17165(), matrices, queue,
						light, state, limbAngle, limbDistance);
				matrices.method_22909();
			});
		});
	}
}
