package dev.emi.trinkets;

import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketSaveData;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.data.EntitySlotLoader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import java.util.Map;

public class TrinketsClient implements ClientModInitializer {
	public static SlotGroup activeGroup;
	public static SlotType activeType;
	public static SlotGroup quickMoveGroup;
	public static SlotType quickMoveType;
	public static int quickMoveTimer;

	@Override
	public void onInitializeClient() {
		ClientPlayNetworking.registerGlobalReceiver(TrinketsNetwork.SYNC_INVENTORY, (payload, context) -> {
			class_310 client = context.client();
			class_1297 entity = client.field_1687.method_8469(payload.entityId());
			if (entity instanceof class_1309) {
				TrinketsApi.getTrinketComponent((class_1309) entity).ifPresent(trinkets -> {
					for (Map.Entry<String, TrinketSaveData.Metadata> entry : payload.inventoryUpdates().entrySet()) {
						String[] split = entry.getKey().split("/");
						String group = split[0];
						String slot = split[1];
						Map<String, TrinketInventory> slots = trinkets.getInventory().get(group);
						if (slots != null) {
							TrinketInventory inv = slots.get(slot);
							if (inv != null) {
								inv.applySyncMetadata(entry.getValue());
							}
						}
					}

					if (entity instanceof class_1657 && ((class_1657) entity).field_7498 instanceof TrinketPlayerScreenHandler screenHandler) {
						screenHandler.trinkets$updateTrinketSlots(false);
						TrinketScreenManager.tryUpdateTrinketsSlot();
					}

					for (Map.Entry<String, class_1799> entry : payload.contentUpdates().entrySet()) {
						String[] split = entry.getKey().split("/");
						String group = split[0];
						String slot = split[1];
						int index = Integer.parseInt(split[2]);
						Map<String, TrinketInventory> slots = trinkets.getInventory().get(group);
						if (slots != null) {
							TrinketInventory inv = slots.get(slot);
							if (inv != null && index < inv.method_5439()) {
								inv.method_5447(index, entry.getValue());
							}
						}
					}
				});
			}
		});
		ClientPlayNetworking.registerGlobalReceiver(TrinketsNetwork.SYNC_SLOTS, (payload, context) -> {

			EntitySlotLoader.CLIENT.setSlots(payload.map());
			class_746 player = context.player();

			if (player != null) {
				((TrinketPlayerScreenHandler) player.field_7498).trinkets$updateTrinketSlots(true);

				class_310 client = context.client();
				if (client.field_1755 instanceof TrinketScreen trinketScreen) {
					trinketScreen.trinkets$updateTrinketSlots();
				}

				for (class_1657 clientWorldPlayer : context.player().method_73183().method_18456()) {
					((TrinketPlayerScreenHandler) clientWorldPlayer.field_7498).trinkets$updateTrinketSlots(true);
				}
			}

		});
		ClientPlayNetworking.registerGlobalReceiver(TrinketsNetwork.BREAK, (payload, context) -> {

			class_310 client = context.client();
			class_1297 e = client.field_1687.method_8469(payload.entityId());
			if (e instanceof class_1309 entity) {
				TrinketsApi.getTrinketComponent(entity).ifPresent(comp -> {
					Map<String, TrinketInventory> groupMap = comp.getInventory().get(payload.group());
					if (groupMap != null) {
						TrinketInventory inv = groupMap.get(payload.slot());
						if (payload.index() < inv.method_5439()) {
							class_1799 stack = inv.method_5438(payload.index());
							SlotReference ref = new SlotReference(inv, payload.index());
							Trinket trinket = TrinketsApi.getTrinket(stack.method_7909());
							trinket.onBreak(stack, ref, entity);
						}
					}
				});
			}

		});
	}
}