package dev.emi.trinkets.api;

import dev.emi.trinkets.api.TrinketEnums.DropRule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class SlotType {

	private final String group;
	private final String name;
	private final int order;
	private final int amount;
	private final class_2960 icon;
	private final Set<class_2960> quickMovePredicates;
	private final Set<class_2960> validatorPredicates;
	private final Set<class_2960> tooltipPredicates;
	private final DropRule dropRule;

	public SlotType(String group, String name, int order, int amount, class_2960 icon, Set<class_2960> quickMovePredicates,
			Set<class_2960> validatorPredicates, Set<class_2960> tooltipPredicates, DropRule dropRule) {
		this.group = group;
		this.name = name;
		this.order = order;
		this.amount = amount;
		this.icon = icon;
		this.quickMovePredicates = quickMovePredicates;
		this.validatorPredicates = validatorPredicates;
		this.tooltipPredicates = tooltipPredicates;
		this.dropRule = dropRule;
	}

	public String getGroup() {
		return group;
	}

	public String getName() {
		return name;
	}

	public int getOrder() {
		return order;
	}

	public int getAmount() {
		return amount;
	}

	public class_2960 getIcon() {
		return icon;
	}

	public Set<class_2960> getQuickMovePredicates() {
		return quickMovePredicates;
	}

	public Set<class_2960> getValidatorPredicates() {
		return validatorPredicates;
	}

	public Set<class_2960> getTooltipPredicates() {
		return tooltipPredicates;
	}

	public DropRule getDropRule() {
		return dropRule;
	}

	public class_5250 getTranslation() {
		return class_2561.method_43471("trinkets.slot." + this.group + "." + this.name);
	}

	public void write(class_2487 data) {
		class_2487 tag = new class_2487();
		tag.method_10582("Group", group);
		tag.method_10582("Name", name);
		tag.method_10569("Order", order);
		tag.method_10569("Amount", amount);
		tag.method_10582("Icon", icon.toString());
		class_2499 quickMovePredicateList = new class_2499();

		for (class_2960 id : quickMovePredicates) {
			quickMovePredicateList.add(class_2519.method_23256(id.toString()));
		}
		tag.method_10566("QuickMovePredicates", quickMovePredicateList);

		class_2499 validatorPredicateList = new class_2499();

		for (class_2960 id : validatorPredicates) {
			validatorPredicateList.add(class_2519.method_23256(id.toString()));
		}
		tag.method_10566("ValidatorPredicates", validatorPredicateList);

		class_2499 tooltipPredicateList = new class_2499();

		for (class_2960 id : tooltipPredicates) {
			tooltipPredicateList.add(class_2519.method_23256(id.toString()));
		}
		tag.method_10566("TooltipPredicates", tooltipPredicateList);
		tag.method_10582("DropRule", dropRule.toString());
		data.method_10566("SlotData", tag);
	}

	public static SlotType read(class_2487 data) {
		class_2487 slotData = data.method_68568("SlotData");
		String group = slotData.method_68564("Group", "");
		String name = slotData.method_68564("Name", "");
		int order = slotData.method_68083("Order", 0);
		int amount = slotData.method_68083("Amount", 0);
		class_2960 icon = class_2960.method_60654(slotData.method_68564("Icon", ""));
		class_2499 quickMoveList = slotData.method_68569("QuickMovePredicates");
		Set<class_2960> quickMovePredicates = new HashSet<>();

		for (class_2520 tag : quickMoveList) {
			if (tag instanceof class_2519 string) {
				quickMovePredicates.add(class_2960.method_60654(string.comp_3831()));
			}
		}
		class_2499 validatorList = slotData.method_68569("ValidatorPredicates");
		Set<class_2960> validatorPredicates = new HashSet<>();

		for (class_2520 tag : validatorList) {
			if (tag instanceof class_2519 string) {
				validatorPredicates.add(class_2960.method_60654(string.comp_3831()));
			}
		}
		class_2499 tooltipList = slotData.method_68569("TooltipPredicates");
		Set<class_2960> tooltipPredicates = new HashSet<>();

		for (class_2520 tag : tooltipList) {
			if (tag instanceof class_2519 string) {
				tooltipPredicates.add(class_2960.method_60654(string.comp_3831()));
			}
		}
		String dropRuleName = slotData.method_68564("DropRule", "");
		DropRule dropRule = DropRule.DEFAULT;

		if (TrinketEnums.DropRule.has(dropRuleName)) {
			dropRule = TrinketEnums.DropRule.valueOf(dropRuleName);
		}
		return new SlotType(group, name, order, amount, icon, quickMovePredicates, validatorPredicates, tooltipPredicates, dropRule);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		SlotType slotType = (SlotType) o;
		return group.equals(slotType.group) && name.equals(slotType.name);
	}

	@Override
	public int hashCode() {
		return Objects.hash(group, name);
	}

	public String getId() {
		return this.group + "/" + this.name;
	}
}
