package dev.emi.trinkets.api;

import com.google.common.collect.Multimap;

import org.ladysnake.cca.api.v3.component.ComponentV3;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public interface TrinketComponent extends ComponentV3 {

	class_1309 getEntity();

	/**
	 * @return A map of names to slot groups available to the entity
	 */
	Map<String, SlotGroup> getGroups();

	/**
	 * @return A map of slot group names, to slot names, to trinket inventories
	 * for the entity. Inventories will respect EAM slot count modifications for
	 * the entity.
	 */
	Map<String, Map<String, TrinketInventory>> getInventory();

	void update();

	void addTemporaryModifiers(Multimap<String, class_1322> modifiers);

	void addPersistentModifiers(Multimap<String, class_1322> modifiers);

	void removeModifiers(Multimap<String, class_1322> modifiers);

	void clearModifiers();

	Multimap<String, class_1322> getModifiers();

	/**
	 * @return Whether the predicate matches any slots available to the entity
	 */
	boolean isEquipped(Predicate<class_1799> predicate);

	/**
	 * @return Whether the item is in any slots available to the entity
	 */
	default boolean isEquipped(class_1792 item) {
		return isEquipped(stack -> stack.method_7909() == item);
	}

	/**
	 * @return All slots that match the provided predicate
	 */
	List<class_3545<SlotReference, class_1799>> getEquipped(Predicate<class_1799> predicate);

	/**
	 * @return All slots that contain the provided item
	 */
	default List<class_3545<SlotReference, class_1799>> getEquipped(class_1792 item) {
		return getEquipped(stack -> stack.method_7909() == item);
	}

	/**
	 * @return All non-empty slots
	 */
	default List<class_3545<SlotReference, class_1799>> getAllEquipped() {
		return getEquipped(stack -> !stack.method_7960());
	}

	/**
	 * Iterates over every slot available to the entity
	 */
	void forEach(BiConsumer<SlotReference, class_1799> consumer);

	Set<TrinketInventory> getTrackingUpdates();

	void clearCachedModifiers();
}