package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public record TrinketsAttributeModifiersComponent(List<Entry> modifiers, boolean showInTooltip) {
	public static final TrinketsAttributeModifiersComponent DEFAULT = new TrinketsAttributeModifiersComponent(List.of(), true);
	private static final Codec<TrinketsAttributeModifiersComponent> BASE_CODEC = RecordCodecBuilder.create((instance) -> {
		return instance.group(
						Entry.CODEC.listOf().fieldOf("modifiers").forGetter(TrinketsAttributeModifiersComponent::modifiers),
						Codec.BOOL.optionalFieldOf("show_in_tooltip", true).forGetter(TrinketsAttributeModifiersComponent::showInTooltip)
				).apply(instance, TrinketsAttributeModifiersComponent::new);
	});
	public static final Codec<TrinketsAttributeModifiersComponent> CODEC = Codec.withAlternative(BASE_CODEC, Entry.CODEC.listOf(), (attributeModifiers) -> {
		return new TrinketsAttributeModifiersComponent(attributeModifiers, true);
	});

	public static final class_9139<class_9129, TrinketsAttributeModifiersComponent> PACKET_CODEC = class_9139.method_56435(
			Entry.PACKET_CODEC.method_56433(class_9135.method_56363()),
			TrinketsAttributeModifiersComponent::modifiers,
			class_9135.field_48547,
			TrinketsAttributeModifiersComponent::showInTooltip,
			TrinketsAttributeModifiersComponent::new);

	public static final class_9331<TrinketsAttributeModifiersComponent> TYPE = class_9331.<TrinketsAttributeModifiersComponent>method_57873().method_57881(CODEC).method_57882(PACKET_CODEC).method_57880();

	public TrinketsAttributeModifiersComponent(List<Entry> modifiers, boolean showInTooltip) {
		this.modifiers = modifiers;
		this.showInTooltip = showInTooltip;
	}

	public TrinketsAttributeModifiersComponent withShowInTooltip(boolean showInTooltip) {
		return new TrinketsAttributeModifiersComponent(this.modifiers, showInTooltip);
	}

	public List<Entry> modifiers() {
		return this.modifiers;
	}

	public boolean showInTooltip() {
		return this.showInTooltip;
	}

	public static Builder builder() {
		return new Builder();
	}

	public static class Builder {
		private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

		Builder() {
		}

		public Builder add(class_6880<class_1320> attribute, class_1322 modifier) {
			return add(attribute, modifier, Optional.empty());
		}

		public Builder add(class_6880<class_1320> attribute, class_1322 modifier, String slot) {
			return add(attribute, modifier, Optional.of(slot));
		}

		public Builder add(class_6880<class_1320> attribute, class_1322 modifier, Optional<String> slot) {
			this.entries.add(new Entry (attribute, modifier, slot));
			return this;
		}

		public TrinketsAttributeModifiersComponent build() {
			return new TrinketsAttributeModifiersComponent(this.entries.build(), true);
		}
	}

	public record Entry(class_6880<class_1320> attribute, class_1322 modifier, Optional<String> slot) {
		public static final Codec<Entry> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
				class_7923.field_41190.method_40294().fieldOf("type").forGetter(Entry::attribute),
				class_1322.field_49232.forGetter(Entry::modifier),
				Codec.STRING.optionalFieldOf("slot").forGetter(Entry::slot)
			).apply(instance, Entry::new));
		public static final class_9139<class_9129, Entry> PACKET_CODEC = class_9139.method_56436(
				class_9135.method_56383(class_7924.field_41251),
				Entry::attribute,
				class_1322.field_49233,
				Entry::modifier,
				class_9135.method_56382(class_9135.field_48554),
				Entry::slot,
				Entry::new);
	}
}