package dev.emi.trinkets.api.client;

import dev.emi.trinkets.api.SlotReference;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_3882;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public interface TrinketRenderer {

	/**
	 * Renders the Trinket
	 *
	 * @param stack The {@link class_1799} for the Trinket being rendered
	 * @param slotReference The exact slot for the item being rendered
	 * @param contextModel The model this Trinket is being rendered on
	 */
	void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_10042> contextModel,
				class_4587 matrices, class_11659 vertexConsumers, int light, class_10042 state,
				float limbAngle, float limbDistance);

	/**
	 * Rotates the rendering for the models based on the entity's poses and movements. This will do
	 * nothing if the entity render object does not implement {@link class_922} or if the
	 * model does not implement {@link class_572}).
	 *
	 * @param entityModel The model of wearer of the trinket
	 * @param model The model to align to the body movement
	 */
	@SuppressWarnings("unchecked")
	static void followBodyRotations(final class_583<? extends class_10042> entityModel, final class_572<?> model) {
		if (entityModel instanceof class_572<?> bipedModel) {
			//noinspection rawtypes
			model.field_3398.method_32085(bipedModel.field_3398.method_32084());
			model.field_3391.method_32085(bipedModel.field_3391.method_32084());
			model.field_27433.method_32085(bipedModel.field_27433.method_32084());
			model.field_3401.method_32085(bipedModel.field_3401.method_32084());
			model.field_3397.method_32085(bipedModel.field_3397.method_32084());
			model.field_3392.method_32085(bipedModel.field_3392.method_32084());
		}
	}

	/**
	 * Translates the rendering context to the center of the player's face
	 */
	static void translateToFace(class_4587 matrices, class_3882 model,
			class_10034 state, float headYaw, float headPitch) {

		if (state.field_53412 || state.field_53411) {
			matrices.method_22907(class_7833.field_40718.rotationDegrees(model.method_2838().field_3674));
			matrices.method_22907(class_7833.field_40716.rotationDegrees(headYaw));
			matrices.method_22907(class_7833.field_40714.rotationDegrees(-45.0F));
		} else {

			if (state.field_53410 || state.method_62613(class_4050.field_40118)) {
				matrices.method_46416(0.0F, 0.25F, 0.0F);
			}
			matrices.method_22907(class_7833.field_40716.rotationDegrees(headYaw));
			matrices.method_22907(class_7833.field_40714.rotationDegrees(headPitch));
		}
		matrices.method_46416(0.0F, -0.25F, -0.3F);
	}

	/**
	 * Translates the rendering context to the center of the player's chest/torso segment
	 */
	static void translateToChest(class_4587 matrices, class_572<?> model,
			class_10034 state) {

		if (state.field_53410 && !state.method_62613(class_4050.field_40118) && !state.field_53412) {
			matrices.method_46416(0.0F, 0.2F, 0.0F);
			matrices.method_22907(class_7833.field_40714.rotation(model.field_3391.field_3654));
		}
		matrices.method_22907(class_7833.field_40716.rotation(model.field_3391.field_3675));
		matrices.method_46416(0.0F, 0.4F, -0.16F);
	}

	/**
	 * Translates the rendering context to the center of the bottom of the player's right arm
	 */
	static void translateToRightArm(class_4587 matrices, class_572<?> model,
			class_10034 state) {

		if (state.field_53410 && !state.method_62613(class_4050.field_40118) && !state.field_53412) {
			matrices.method_46416(0.0F, 0.2F, 0.0F);
		}
		matrices.method_22907(class_7833.field_40716.rotation(model.field_3391.field_3675));
		matrices.method_46416(-0.3125F, 0.15625F, 0.0F);
		matrices.method_22907(class_7833.field_40718.rotation(model.field_3401.field_3674));
		matrices.method_22907(class_7833.field_40716.rotation(model.field_3401.field_3675));
		matrices.method_22907(class_7833.field_40714.rotation(model.field_3401.field_3654));
		matrices.method_46416(-0.0625F, 0.625F, 0.0F);
	}

	/**
	 * Translates the rendering context to the center of the bottom of the player's left arm
	 */
	static void translateToLeftArm(class_4587 matrices, class_572<?> model,
			class_10034 state) {

		if (state.field_53410 && !state.method_62613(class_4050.field_40118) && !state.field_53412) {
			matrices.method_46416(0.0F, 0.2F, 0.0F);
		}
		matrices.method_22907(class_7833.field_40716.rotation(model.field_3391.field_3675));
		matrices.method_46416(0.3125F, 0.15625F, 0.0F);
		matrices.method_22907(class_7833.field_40718.rotation(model.field_27433.field_3674));
		matrices.method_22907(class_7833.field_40716.rotation(model.field_27433.field_3675));
		matrices.method_22907(class_7833.field_40714.rotation(model.field_27433.field_3654));
		matrices.method_46416(0.0625F, 0.625F, 0.0F);
	}

	/**
	 * Translates the rendering context to the center of the bottom of the player's right leg
	 */
	static void translateToRightLeg(class_4587 matrices, class_572<?> model,
			class_10034 state) {

		if (state.field_53410 && !state.method_62613(class_4050.field_40118) && !state.field_53412) {
			matrices.method_46416(0.0F, 0.0F, 0.25F);
		}
		matrices.method_46416(-0.125F, 0.75F, 0.0F);
		matrices.method_22907(class_7833.field_40718.rotation(model.field_3392.field_3674));
		matrices.method_22907(class_7833.field_40716.rotation(model.field_3392.field_3675));
		matrices.method_22907(class_7833.field_40714.rotation(model.field_3392.field_3654));
		matrices.method_46416(0.0F, 0.75F, 0.0F);
	}

	/**
	 * Translates the rendering context to the center of the bottom of the player's left leg
	 */
	static void translateToLeftLeg(class_4587 matrices, class_572<?> model,
			class_10034 state) {
		if (state.field_53410 && !state.method_62613(class_4050.field_40118) && !state.field_53412) {
			matrices.method_46416(0.0F, 0.0F, 0.25F);
		}
		matrices.method_46416(0.125F, 0.75F, 0.0F);
		matrices.method_22907(class_7833.field_40718.rotation(model.field_3397.field_3674));
		matrices.method_22907(class_7833.field_40716.rotation(model.field_3397.field_3675));
		matrices.method_22907(class_7833.field_40714.rotation(model.field_3397.field_3654));
		matrices.method_46416(0.0F, 0.75F, 0.0F);
	}
}
