package dev.emi.trinkets.compat;

import dev.emi.trinkets.TrinketScreen;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import net.minecraft.class_437;

public class TrinketsREIPlugin implements REIClientPlugin {

	@Override
	public void registerExclusionZones(ExclusionZones zones) {
		zones.register(TrinketScreen.class, screen -> {
			if (screen instanceof class_437 guiScreen) {
				return TrinketsExclusionAreas.create(guiScreen).stream().map(
					rect2i -> new Rectangle(rect2i.method_3321(), rect2i.method_3322(), rect2i.method_3319(),
						rect2i.method_3320())).collect(Collectors.toList());
			}
			return List.of();
		});
	}
}
