package dev.emi.trinkets.data;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsMain;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.data.SlotLoader.GroupData;
import dev.emi.trinkets.data.SlotLoader.SlotData;
import dev.emi.trinkets.payload.SyncSlotsPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7923;

public class EntitySlotLoader extends class_4080<Map<String, Map<String, Set<String>>>> implements IdentifiableResourceReloadListener {

	public static final EntitySlotLoader CLIENT = new EntitySlotLoader();
	public static final EntitySlotLoader SERVER = new EntitySlotLoader();

	private static final Gson GSON = (new GsonBuilder()).setPrettyPrinting().disableHtmlEscaping().create();
	private static final class_2960 ID = class_2960.method_60655(TrinketsMain.MOD_ID, "entities");

	private final Map<class_1299<?>, Map<String, SlotGroup>> slots = new HashMap<>();

	@Override
	protected Map<String, Map<String, Set<String>>> method_18789(class_3300 resourceManager, class_3695 profiler) {
		Map<String, Map<String, Set<String>>> map = new HashMap<>();
		String dataType = "entities";

		for (Map.Entry<class_2960, List<class_3298>> entry : resourceManager.method_41265(dataType, id -> id.method_12832().endsWith(".json")).entrySet()) {
			class_2960 identifier = entry.getKey();

			if (identifier.method_12836().equals(TrinketsMain.MOD_ID)) {

				try {
					for (class_3298 resource : entry.getValue()) {
						InputStreamReader reader = new InputStreamReader(resource.method_14482());
						JsonObject jsonObject = class_3518.method_15276(GSON, reader, JsonObject.class);

						if (jsonObject != null) {

							try {
								boolean replace = class_3518.method_15258(jsonObject, "replace", false);
								JsonArray assignedSlots = class_3518.method_15292(jsonObject, "slots", new JsonArray());
								Map<String, Set<String>> groups = new HashMap<>();

								if (assignedSlots != null) {

									for (JsonElement assignedSlot : assignedSlots) {
										String slot = assignedSlot.getAsString();
										String[] parsedSlot = slot.split("/");

										if (parsedSlot.length != 2) {
											TrinketsMain.LOGGER.error("Detected malformed slot assignment " + slot
													+ "! Slots should be in the format 'group/slot'.");
											continue;
										}
										String group = parsedSlot[0];
										String name = parsedSlot[1];
										groups.computeIfAbsent(group, (k) -> new HashSet<>()).add(name);
									}
								}
								JsonArray entities = class_3518.method_15292(jsonObject, "entities", new JsonArray());

								if (!groups.isEmpty() && entities != null) {

									for (JsonElement entity : entities) {
										String name = entity.getAsString();
										String id;

										if (name.startsWith("#")) {
											id = "#" + class_2960.method_60654(name.substring(1));
										} else {
											id = class_2960.method_60654(name).toString();
										}
										Map<String, Set<String>> slots = map.computeIfAbsent(id, (k) -> new HashMap<>());

										if (replace) {
											slots.clear();
										}
										groups.forEach((groupName, slotNames) -> slots.computeIfAbsent(groupName, (k) -> new HashSet<>())
												.addAll(slotNames));
									}
								}
							} catch (JsonSyntaxException e) {
								TrinketsMain.LOGGER.error("[trinkets] Syntax error while reading data for " + identifier.method_12832());
								e.printStackTrace();
							}
						}

					}
				} catch (IOException e) {
					TrinketsMain.LOGGER.error("[trinkets] Unknown IO error while reading slot data!");
					e.printStackTrace();
				}
			}
		}
		return map;
	}

	@Override
	protected void apply(Map<String, Map<String, Set<String>>> loader, class_3300 manager, class_3695 profiler) {
		Map<String, GroupData> slots = SlotLoader.INSTANCE.getSlots();
		Map<class_1299<?>, Map<String, SlotGroup.Builder>> groupBuilders = new HashMap<>();

		loader.forEach((entityName, groups) -> {
			Set<class_1299<?>> types = new HashSet<>();

			try {
				if (entityName.startsWith("#")) {
					// TODO rewrite this to work with the new tag system
					TrinketsMain.LOGGER.error("[trinkets] Attempted to assign entity entry to tag");
					/*
					TagKey<EntityType<?>> tag = TagKey.of(Registry.ENTITY_TYPE_KEY, Identifier.of(entityName.substring(1)));
					List<? extends EntityType<?>> entityTypes = Registry.ENTITY_TYPE.getEntryList(tag)
							.orElseThrow(() -> new IllegalArgumentException("Unknown entity tag '" + entityName + "'"))
							.stream()
							.map(RegistryEntry::value)
							.toList();

					types.addAll(entityTypes);*/
				} else {
					types.add(class_7923.field_41177.method_17966(class_2960.method_60654(entityName))
							.orElseThrow(() -> new IllegalArgumentException("Unknown entity '" + entityName + "'")));
				}
			} catch (IllegalArgumentException e) {
				TrinketsMain.LOGGER.error("[trinkets] Attempted to assign unknown entity entry " + entityName);
			}

			for (class_1299<?> type : types) {
				Map<String, SlotGroup.Builder> builders = groupBuilders.computeIfAbsent(type, (k) -> new HashMap<>());
				groups.forEach((groupName, slotNames) -> {
					GroupData group = slots.get(groupName);

					if (group != null) {
						SlotGroup.Builder builder = builders.computeIfAbsent(groupName,
								(k) -> new SlotGroup.Builder(groupName, group.getSlotId(), group.getOrder()));
						slotNames.forEach(slotName -> {
							SlotData slotData = group.getSlot(slotName);

							if (slotData != null) {
								builder.addSlot(slotName, slotData.create(groupName, slotName));
							} else {
								TrinketsMain.LOGGER.error("[trinkets] Attempted to assign unknown slot " + slotName);
							}
						});
					} else {
						TrinketsMain.LOGGER.error("[trinkets] Attempted to assign slot from unknown group " + groupName);
					}
				});
			}
		});
		this.slots.clear();

		groupBuilders.forEach((entity, groups) -> {
			Map<String, SlotGroup> entitySlots = this.slots.computeIfAbsent(entity, (k) -> new HashMap<>());
			groups.forEach((groupName, groupBuilder) -> entitySlots.putIfAbsent(groupName, groupBuilder.build()));
		});
	}

	public Map<String, SlotGroup> getEntitySlots(class_1299<?> entityType) {
		if (this.slots.containsKey(entityType)) {
			return ImmutableMap.copyOf(this.slots.get(entityType));
		}
		return ImmutableMap.of();
	}

	public void setSlots(Map<class_1299<?>, Map<String, SlotGroup>> slots) {
		this.slots.clear();
		this.slots.putAll(slots);
	}

	public void sync(class_3222 playerEntity) {
		ServerPlayNetworking.send(playerEntity, new SyncSlotsPayload(Map.copyOf(this.slots)));
	}

	public void sync(List<? extends class_3222> players) {
		SyncSlotsPayload packet = new SyncSlotsPayload(Map.copyOf(this.slots));
		players.forEach(player -> ServerPlayNetworking.send(player, packet));
		players.forEach(player -> ((TrinketPlayerScreenHandler) player.field_7498).trinkets$updateTrinketSlots(true));
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	@Override
	public Collection<class_2960> getFabricDependencies() {
		return Lists.newArrayList(SlotLoader.ID);
	}
}