package dev.emi.trinkets.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.emi.trinkets.TrinketSlotTarget;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1887;

@Mixin(class_1887.class_9427.class)
public class EnchantmentDefinitionMixin implements TrinketSlotTarget {
	@Unique
	private Set<String> trinketSlots = Set.of();


	@Override
	public Set<String> trinkets$slots() {
		return this.trinketSlots;
	}

	@Override
	public void trinkets$slots(Set<String> slots) {
		this.trinketSlots = slots;
	}

	@ModifyExpressionValue(method = "<clinit>", at = @At(value = "INVOKE", target = "Lcom/mojang/serialization/codecs/RecordCodecBuilder;mapCodec(Ljava/util/function/Function;)Lcom/mojang/serialization/MapCodec;"))
	private static MapCodec<class_1887.class_9427> extendCodec(MapCodec<class_1887.class_9427> codec) {
		return RecordCodecBuilder.mapCodec(instance -> instance.group(
				codec.forGetter(Function.identity()),
				Codec.list(Codec.STRING).xmap(Set::copyOf, List::copyOf)
						.optionalFieldOf("trinkets:slots", Set.of())
						.forGetter(x -> ((TrinketSlotTarget) (Object) x).trinkets$slots())
			).apply(instance, (class_1887.class_9427 def, Set<String> slots) -> {
				((TrinketSlotTarget) (Object) def).trinkets$slots(slots);
				return def;
			}));
	}
}
