package dev.emi.trinkets.mixin;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9699;
import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.TrinketSlotTarget;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * Allows enchantments to work on trinket items when used in global entity context
 *
 * @author Patbox
 */
@Mixin(class_1890.class)
public abstract class EnchantmentHelperMixin {

	@Inject(at = @At("TAIL"), method = "forEachEnchantment(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/enchantment/EnchantmentHelper$ContextAwareConsumer;)V")
	private static void forEachTrinket(class_1309 entity, class_1890.class_9702 contextAwareConsumer, CallbackInfo info) {
		Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent(entity);
		if (optional.isPresent()) {
			TrinketComponent comp = optional.get();
			comp.forEach((ref, stack) -> {
				if (!stack.method_7960()) {
					class_9304 enchantments = stack.method_58694(class_9334.field_49633);
					if (enchantments != null && !enchantments.method_57543()) {
						class_9699 context = new class_9699(stack, null, entity, (item) -> {
							TrinketsApi.onTrinketBroken(stack, ref, entity);
						});

						for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
							class_6880<class_1887> registryEntry = entry.getKey();
							List<class_9274> slots = registryEntry.comp_349().comp_2687().comp_2513();
							Set<String> trinketSlots = ((TrinketSlotTarget) (Object) registryEntry.comp_349().comp_2687()).trinkets$slots();

							if (slots.contains(class_9274.field_49216) || slots.contains(class_9274.field_49224) || trinketSlots.contains(ref.inventory().getSlotType().getId())) {
								contextAwareConsumer.accept(registryEntry, entry.getIntValue(), context);
							}
						}
					}
				}
			});
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal = 0), method = "chooseEquipmentWith")
	private static void addTrinketsAsChoices(class_9331<?> componentType, class_1309 entity, Predicate<class_1799> stackPredicate, CallbackInfoReturnable<Optional<class_9699>> info, @Local List<class_9699> list) {
		Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent(entity);
		if (optional.isPresent()) {
			TrinketComponent comp = optional.get();
			comp.forEach((ref, stack) -> {
				if (stackPredicate.test(stack)) {
					class_9304 enchantments = stack.method_58695(class_9334.field_49633, class_9304.field_49385);
					for(Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
						class_6880<class_1887> registryEntry = entry.getKey();
						List<class_9274> slots = registryEntry.comp_349().comp_2687().comp_2513();
						Set<String> trinketSlots = ((TrinketSlotTarget) (Object) registryEntry.comp_349().comp_2687()).trinkets$slots();

						if (registryEntry.comp_349().comp_2689().method_57832(componentType)
								&& (slots.contains(class_9274.field_49216) || slots.contains(class_9274.field_49224)
								|| trinketSlots.contains(ref.inventory().getSlotType().getId()))
						) {
							list.add(new class_9699(stack, null, entity, (item) -> {
								TrinketsApi.onTrinketBroken(stack, ref, entity);
							}));
						}
					}
				}
			});
		}
	}
}