package dev.emi.trinkets.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketSaveData;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import dev.emi.trinkets.payload.SyncInventoryPayload;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes.SlotEntityAttribute;
import dev.emi.trinkets.api.TrinketEnums.DropRule;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_5131;
import net.minecraft.class_6880;
import net.minecraft.class_9701;

/**
 * Trinket dropping on death, trinket EAMs, and trinket equip/unequip calls
 *
 * @author Emi
 */
@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
	@Unique
	private final Map<String, class_1799> lastEquippedTrinkets = new HashMap<>();

	@Shadow
	public abstract class_5131 getAttributes();

	private LivingEntityMixin() {
		super(null, null);
	}

	@Inject(at = @At("HEAD"), method = "canFreeze", cancellable = true)
	private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Optional<TrinketComponent> component = TrinketsApi.getTrinketComponent((class_1309) (Object) this);
		if (component.isPresent()) {
			for (class_3545<SlotReference, class_1799> equipped : component.get().getAllEquipped()) {
				if (equipped.method_15441().method_31573(class_3489.field_28041)) {
					cir.setReturnValue(false);
					break;
				}
			}
		}
	}

	@Inject(at = @At("TAIL"), method = "dropInventory")
	private void dropInventory(class_3218 world, CallbackInfo info) {
		class_1309 entity = (class_1309) (Object) this;

		boolean keepInv = world.method_64395().method_76185(class_1928.field_19389);
		TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
			if (stack.method_7960()) {
				return;
			}

			DropRule dropRule = TrinketsApi.getTrinket(stack.method_7909()).getDropRule(stack, ref, entity);

			dropRule = TrinketDropCallback.EVENT.invoker().drop(dropRule, stack, ref, entity);

			TrinketInventory inventory = ref.inventory();

			if (dropRule == DropRule.DEFAULT) {
				dropRule = inventory.getSlotType().getDropRule();
			}

			if (dropRule == DropRule.DEFAULT) {
				if (keepInv && entity.method_5864() == class_1299.field_6097) {
					dropRule = DropRule.KEEP;
				} else {
					if (class_1890.method_60142(stack, class_9701.field_51655)) {
						dropRule = DropRule.DESTROY;
					} else {
						dropRule = DropRule.DROP;
					}
				}
			}

			switch (dropRule) {
				case DROP:
					dropFromEntity(stack);
					// Fallthrough
				case DESTROY:
					inventory.method_5447(ref.index(), class_1799.field_8037);
					break;
				default:
					break;
			}
		}));
	}

	@Unique
	private void dropFromEntity(class_1799 stack) {
		// Mimic player drop behavior for only players
		if (((class_1297) this) instanceof class_1657 player) {
			class_1542 entity = player.method_7329(stack, true, false);
		} else if (this.method_73183() instanceof class_3218 serverWorld) {
			class_1542 entity = method_5775(serverWorld, stack);
		}
	}

	@Inject(at = @At("TAIL"), method = "tick")
	private void tick(CallbackInfo info) {
		class_1309 entity = (class_1309) (Object) this;
		if (entity.method_31481()) {
			return;
		}
		TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> {
			Map<String, class_1799> newlyEquippedTrinkets = new HashMap<>();
			Map<String, class_1799> contentUpdates = new HashMap<>();
			trinkets.forEach((ref, stack) -> {
				TrinketInventory inventory = ref.inventory();
				SlotType slotType = inventory.getSlotType();
				int index = ref.index();
				class_1799 oldStack = getOldStack(slotType, index);
				class_1799 newStack = inventory.method_5438(index);
				class_1799 newStackCopy = newStack.method_7972();
				String newRef = slotType.getGroup() + "/" + slotType.getName() + "/" + index;

				if (!class_1799.method_7973(newStack, oldStack)) {

					TrinketsApi.getTrinket(oldStack.method_7909()).onUnequip(oldStack, ref, entity);
					TrinketUnequipCallback.EVENT.invoker().onUnequip(oldStack, ref, entity);
					TrinketsApi.getTrinket(newStack.method_7909()).onEquip(newStack, ref, entity);
					TrinketEquipCallback.EVENT.invoker().onEquip(newStack, ref, entity);

					class_1937 world = this.method_73183();
					if (!world.method_8608()) {
						contentUpdates.put(newRef, newStackCopy);

						if (!oldStack.method_7960()) {
							Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(oldStack, ref, entity);
							Multimap<String, class_1322> slotMap = HashMultimap.create();
							Set<class_6880<class_1320>> toRemove = Sets.newHashSet();
							for (class_6880<class_1320> attr : map.keySet()) {
								if (attr.method_40227() && attr.comp_349() instanceof SlotEntityAttribute slotAttr) {
									slotMap.putAll(slotAttr.slot, map.get(attr));
									toRemove.add(attr);
								}
							}
							for (class_6880<class_1320> attr : toRemove) {
								map.removeAll(attr);
							}
							//this.getAttributes().removeModifiers(map);
							map.asMap().forEach((attribute, modifiers) -> {
								class_1324 entityAttributeInstance = this.getAttributes().method_45329(attribute);
								if (entityAttributeInstance != null) {
									modifiers.forEach(modifier -> entityAttributeInstance.method_6200(modifier.comp_2447()));
								}
							});

							trinkets.removeModifiers(slotMap);
						}

						if (!newStack.method_7960()) {
							Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(newStack, ref, entity);
							Multimap<String, class_1322> slotMap = HashMultimap.create();
							Set<class_6880<class_1320>> toRemove = Sets.newHashSet();
							for (class_6880<class_1320> attr : map.keySet()) {
								if (attr.method_40227() && attr.comp_349() instanceof SlotEntityAttribute slotAttr) {
									slotMap.putAll(slotAttr.slot, map.get(attr));
									toRemove.add(attr);
								}
							}
							for (class_6880<class_1320> attr : toRemove) {
								map.removeAll(attr);
							}
							//this.getAttributes().addTemporaryModifiers(map);
							map.forEach((attribute, attributeModifier) -> {
								class_1324 entityAttributeInstance = this.getAttributes().method_45329(attribute);
								if (entityAttributeInstance != null) {
									entityAttributeInstance.method_6200(attributeModifier.comp_2447());
									entityAttributeInstance.method_26835(attributeModifier);
								}

							});
							trinkets.addTemporaryModifiers(slotMap);
						}
					}
				}
				TrinketsApi.getTrinket(newStack.method_7909()).tick(newStack, ref, entity);
				class_1799 tickedStack = inventory.method_5438(index);
				// Avoid calling equip/unequip on stacks that mutate themselves
				if (tickedStack.method_7909() == newStackCopy.method_7909()) {
					newlyEquippedTrinkets.put(newRef, tickedStack.method_7972());
				} else {
					newlyEquippedTrinkets.put(newRef, newStackCopy);
				}
			});

			class_1937 world = this.method_73183();
			if (!world.method_8608()) {
				Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();

				if (!contentUpdates.isEmpty() || !inventoriesToSend.isEmpty()) {
                    Map<String, TrinketSaveData.Metadata> map = new HashMap<>();

					for (TrinketInventory trinketInventory : inventoriesToSend) {
						map.put(trinketInventory.getSlotType().getId(), trinketInventory.getSyncMetadata());
					}
                    SyncInventoryPayload packet = new SyncInventoryPayload(this.method_5628(), contentUpdates, map);

					for (class_3222 player : PlayerLookup.tracking(entity)) {
						ServerPlayNetworking.send(player, packet);
					}

					if (entity instanceof class_3222 serverPlayer) {
						ServerPlayNetworking.send(serverPlayer, packet);

						if (!inventoriesToSend.isEmpty()) {
							((TrinketPlayerScreenHandler) serverPlayer.field_7498).trinkets$updateTrinketSlots(false);
						}
					}

					inventoriesToSend.clear();
				}
			}

			lastEquippedTrinkets.clear();
			lastEquippedTrinkets.putAll(newlyEquippedTrinkets);
		});
	}

	@Unique
	private class_1799 getOldStack(SlotType type, int index) {
		return lastEquippedTrinkets.getOrDefault(type.getGroup() + "/" + type.getName() + "/" + index, class_1799.field_8037);
	}
}