package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketEntityRenderState;
import dev.emi.trinkets.api.SlotReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;

@Environment(EnvType.CLIENT)
@Mixin(class_10042.class)
public class LivingEntityStateRenderMixin implements TrinketEntityRenderState {

    @Unique
    private List<class_3545<class_1799, SlotReference>> trinketsState;

    @Override
    public void trinkets$setState(List<class_3545<class_1799, SlotReference>> items) {
        this.trinketsState = items;
    }

    @Override
    public List<class_3545<class_1799, SlotReference>> trinkets$getState() {
        return this.trinketsState;
    }
}
