package dev.emi.trinkets.mixin;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import dev.emi.trinkets.Point;
import dev.emi.trinkets.SurvivalTrinketSlot;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.mixin.accessor.ScreenHandlerAccessor;

/**
 * Adds trinket slots to the player's screen handler
 *
 * @author Emi
 */
@Mixin(class_1723.class)
public abstract class PlayerScreenHandlerMixin extends class_1703 implements TrinketPlayerScreenHandler {
	@Shadow @Final
	private class_1657 owner;

	@Unique
	private final Map<SlotGroup, Integer> groupNums = new HashMap<>();
	@Unique
	private final Map<SlotGroup, Point> groupPos = new HashMap<>();
	@Unique
	private final Map<SlotGroup, List<Point>> slotHeights = new HashMap<>();
	@Unique
	private final Map<SlotGroup, List<SlotType>> slotTypes = new HashMap<>();
	@Unique
	private final Map<SlotGroup, Integer> slotWidths = new HashMap<>();
	@Unique
	private int trinketSlotStart = 0;
	@Unique
	private int trinketSlotEnd = 0;
	@Unique
	private int groupCount = 0;
	@Unique
	private class_1661 inventory;

	private PlayerScreenHandlerMixin() {
		super(null, 0);
	}

	@Inject(at = @At("RETURN"), method = "<init>")
	private void init(class_1661 playerInv, boolean onServer, class_1657 owner, CallbackInfo info) {
		this.inventory = playerInv;
		trinkets$updateTrinketSlots(true);
	}

	@Override
	public void trinkets$updateTrinketSlots(boolean slotsChanged) {
		TrinketsApi.getTrinketComponent(owner).ifPresent(trinkets -> {
			if (slotsChanged) {
				trinkets.update();
			}
			Map<String, SlotGroup> groups = trinkets.getGroups();
			groupPos.clear();
			while (trinketSlotStart < trinketSlotEnd) {
				field_7761.remove(trinketSlotStart);
				((ScreenHandlerAccessor) (this)).getTrackedStacks().remove(trinketSlotStart);
				((ScreenHandlerAccessor) (this)).getTrackedSlots().remove(trinketSlotStart);
				trinketSlotEnd--;
			}

			int groupNum = 1; // Start at 1 because offhand exists

			for (SlotGroup group : groups.values().stream().sorted(Comparator.comparing(SlotGroup::getOrder)).toList()) {
				if (!hasSlots(trinkets, group)) {
					continue;
				}
				int id = group.getSlotId();
				if (id != -1) {
					if (this.field_7761.size() > id) {
						class_1735 slot = this.field_7761.get(id);
						if (!(slot instanceof SurvivalTrinketSlot)) {
							groupPos.put(group, new Point(slot.field_7873, slot.field_7872));
							groupNums.put(group, -id);
						}
					}
				} else {
					int x = 77;
					int y;
					if (groupNum >= 4) {
						x = 4 - (groupNum / 4) * 18;
						y = 8 + (groupNum % 4) * 18;
					} else {
						y = 62 - groupNum * 18;
					}
					groupPos.put(group, new Point(x, y));
					groupNums.put(group, groupNum);
					groupNum++;
				}
			}
			groupCount = Math.max(0, groupNum - 4);
			trinketSlotStart = field_7761.size();
			slotWidths.clear();
			slotHeights.clear();
			slotTypes.clear();
			for (Map.Entry<String, Map<String, TrinketInventory>> entry : trinkets.getInventory().entrySet()) {
				String groupId = entry.getKey();
				SlotGroup group = groups.get(groupId);
				int groupOffset = 1;

				if (group.getSlotId() != -1) {
					groupOffset++;
				}
				int width = 0;
				Point pos = trinkets$getGroupPos(group);
				if (pos == null) {
					continue;
				}
				for (Map.Entry<String, TrinketInventory> slot : entry.getValue().entrySet().stream().sorted((a, b) ->
						Integer.compare(a.getValue().getSlotType().getOrder(), b.getValue().getSlotType().getOrder())).toList()) {
					TrinketInventory stacks = slot.getValue();
					if (stacks.method_5439() == 0) {
						continue;
					}
					int slotOffset = 1;
					int x = (int) ((groupOffset / 2) * 18 * Math.pow(-1, groupOffset));
					slotHeights.computeIfAbsent(group, (k) -> new ArrayList<>()).add(new Point(x, stacks.method_5439()));
					slotTypes.computeIfAbsent(group, (k) -> new ArrayList<>()).add(stacks.getSlotType());
					for (int i = 0; i < stacks.method_5439(); i++) {
						int y = (int) (pos.y() + (slotOffset / 2) * 18 * Math.pow(-1, slotOffset));
						this.method_7621(new SurvivalTrinketSlot(stacks, i, x + pos.x(), y, group, stacks.getSlotType(), i, groupOffset == 1 && i == 0));
						slotOffset++;
					}
					groupOffset++;
					width++;
				}
				slotWidths.put(group, width);
			}

			trinketSlotEnd = field_7761.size();
		});
	}

	@Unique
	private boolean hasSlots(TrinketComponent comp, SlotGroup group) {
		for (TrinketInventory inv : comp.getInventory().get(group.getName()).values()) {
			if (inv.method_5439() > 0) {
				return true;
			}
		}
		return false;
	}

	@Override
	public int trinkets$getGroupNum(SlotGroup group) {
		return groupNums.getOrDefault(group, 0);
	}

	@Nullable
	@Override
	public Point trinkets$getGroupPos(SlotGroup group) {
		return groupPos.get(group);
	}

	@NotNull
	@Override
	public List<Point> trinkets$getSlotHeights(SlotGroup group) {
		return slotHeights.getOrDefault(group, ImmutableList.of());
	}

	@Nullable
	@Override
	public Point trinkets$getSlotHeight(SlotGroup group, int i) {
		List<Point> points = this.trinkets$getSlotHeights(group);
		return i < points.size() ? points.get(i) : null;
	}

	@NotNull
	@Override
	public List<SlotType> trinkets$getSlotTypes(SlotGroup group) {
		return slotTypes.getOrDefault(group, ImmutableList.of());
	}

	@Override
	public int trinkets$getSlotWidth(SlotGroup group) {
		return slotWidths.getOrDefault(group, 0);
	}

	@Override
	public int trinkets$getGroupCount() {
		return groupCount;
	}

	@Override
	public int trinkets$getTrinketSlotStart() {
		return trinketSlotStart;
	}

	@Override
	public int trinkets$getTrinketSlotEnd() {
		return trinketSlotEnd;
	}

	@Inject(at = @At("HEAD"), method = "onClosed")
	private void onClosed(class_1657 player, CallbackInfo info) {
		class_1937 world = player.method_73183();
		if (world.method_8608()) {
			TrinketsClient.activeGroup = null;
			TrinketsClient.activeType = null;
			TrinketsClient.quickMoveGroup = null;
		}
	}

	@Inject(at = @At("HEAD"), method = "quickMove", cancellable = true)
	private void quickMove(class_1657 player, int index, CallbackInfoReturnable<class_1799> info) {
		class_1735 slot = field_7761.get(index);

		if (slot.method_7681()) {
			class_1799 stack = slot.method_7677();
			if (index >= trinketSlotStart && index < trinketSlotEnd) {
				if (!this.method_7616(stack, 9, 45, false)) {
					info.setReturnValue(class_1799.field_8037);
				} else {
					info.setReturnValue(stack);
				}
			} else if (index >= 9 && index < 45) {
				TrinketsApi.getTrinketComponent(player).ifPresent(trinkets -> {
						for (int i = trinketSlotStart; i < trinketSlotEnd; i++) {
							class_1735 s = field_7761.get(i);
							if (!(s instanceof SurvivalTrinketSlot) || !s.method_7680(stack)) {
								continue;
							}

							SurvivalTrinketSlot ts = (SurvivalTrinketSlot) s;
							SlotType type = ts.getType();
							SlotReference ref = new SlotReference((TrinketInventory) ts.field_7871, ts.method_34266());

							boolean res = TrinketsApi.evaluatePredicateSet(type.getQuickMovePredicates(), stack, ref, player);

							if (res) {
								if (this.method_7616(stack, i, i + 1, false)) {
									class_1937 world = player.method_73183();
									if (world.method_8608()) {
										TrinketsClient.quickMoveTimer = 20;
										TrinketsClient.quickMoveGroup = TrinketsApi.getPlayerSlots(this.owner).get(type.getGroup());
										if (ref.index() > 0) {
											TrinketsClient.quickMoveType = type;
										} else {
											TrinketsClient.quickMoveType = null;
										}
									}
								}
							}
						}
					}
				);
			}
		}
	}
}