/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import dev.emi.trinkets.api.TrinketEnums;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class SlotType {
    private final String group;
    private final String name;
    private final int order;
    private final int amount;
    private final class_2960 icon;
    private final Set<class_2960> quickMovePredicates;
    private final Set<class_2960> validatorPredicates;
    private final Set<class_2960> tooltipPredicates;
    private final TrinketEnums.DropRule dropRule;

    public SlotType(String group, String name, int order, int amount, class_2960 icon, Set<class_2960> quickMovePredicates, Set<class_2960> validatorPredicates, Set<class_2960> tooltipPredicates, TrinketEnums.DropRule dropRule) {
        this.group = group;
        this.name = name;
        this.order = order;
        this.amount = amount;
        this.icon = icon;
        this.quickMovePredicates = quickMovePredicates;
        this.validatorPredicates = validatorPredicates;
        this.tooltipPredicates = tooltipPredicates;
        this.dropRule = dropRule;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public int getAmount() {
        return this.amount;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public Set<class_2960> getQuickMovePredicates() {
        return this.quickMovePredicates;
    }

    public Set<class_2960> getValidatorPredicates() {
        return this.validatorPredicates;
    }

    public Set<class_2960> getTooltipPredicates() {
        return this.tooltipPredicates;
    }

    public TrinketEnums.DropRule getDropRule() {
        return this.dropRule;
    }

    public class_5250 getTranslation() {
        return class_2561.method_43471((String)("trinkets.slot." + this.group + "." + this.name));
    }

    public void write(class_2487 data) {
        class_2487 tag = new class_2487();
        tag.method_10582("Group", this.group);
        tag.method_10582("Name", this.name);
        tag.method_10569("Order", this.order);
        tag.method_10569("Amount", this.amount);
        tag.method_10582("Icon", this.icon.toString());
        class_2499 quickMovePredicateList = new class_2499();
        for (class_2960 class_29602 : this.quickMovePredicates) {
            quickMovePredicateList.add((Object)class_2519.method_23256((String)class_29602.toString()));
        }
        tag.method_10566("QuickMovePredicates", (class_2520)quickMovePredicateList);
        class_2499 validatorPredicateList = new class_2499();
        for (class_2960 id : this.validatorPredicates) {
            validatorPredicateList.add((Object)class_2519.method_23256((String)id.toString()));
        }
        tag.method_10566("ValidatorPredicates", (class_2520)validatorPredicateList);
        class_2499 class_24992 = new class_2499();
        for (class_2960 id : this.tooltipPredicates) {
            class_24992.add((Object)class_2519.method_23256((String)id.toString()));
        }
        tag.method_10566("TooltipPredicates", (class_2520)class_24992);
        tag.method_10582("DropRule", this.dropRule.toString());
        data.method_10566("SlotData", (class_2520)tag);
    }

    public static SlotType read(class_2487 data) {
        class_2487 slotData = data.method_68568("SlotData");
        String group = slotData.method_68564("Group", "");
        String name = slotData.method_68564("Name", "");
        int order = slotData.method_68083("Order", 0);
        int amount = slotData.method_68083("Amount", 0);
        class_2960 icon = class_2960.method_60654((String)slotData.method_68564("Icon", ""));
        class_2499 quickMoveList = slotData.method_68569("QuickMovePredicates");
        HashSet<class_2960> quickMovePredicates = new HashSet<class_2960>();
        for (class_2520 tag : quickMoveList) {
            if (!(tag instanceof class_2519)) continue;
            class_2519 string = (class_2519)tag;
            quickMovePredicates.add(class_2960.method_60654((String)string.comp_3831()));
        }
        class_2499 validatorList = slotData.method_68569("ValidatorPredicates");
        HashSet<class_2960> validatorPredicates = new HashSet<class_2960>();
        for (class_2520 tag : validatorList) {
            if (!(tag instanceof class_2519)) continue;
            class_2519 string = (class_2519)tag;
            validatorPredicates.add(class_2960.method_60654((String)string.comp_3831()));
        }
        class_2499 tooltipList = slotData.method_68569("TooltipPredicates");
        HashSet<class_2960> tooltipPredicates = new HashSet<class_2960>();
        for (class_2520 tag : tooltipList) {
            if (!(tag instanceof class_2519)) continue;
            class_2519 string = (class_2519)tag;
            tooltipPredicates.add(class_2960.method_60654((String)string.comp_3831()));
        }
        String dropRuleName = slotData.method_68564("DropRule", "");
        TrinketEnums.DropRule dropRule = TrinketEnums.DropRule.DEFAULT;
        if (TrinketEnums.DropRule.has(dropRuleName)) {
            dropRule = TrinketEnums.DropRule.valueOf(dropRuleName);
        }
        return new SlotType(group, name, order, amount, icon, quickMovePredicates, validatorPredicates, tooltipPredicates, dropRule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotType slotType = (SlotType)o;
        return this.group.equals(slotType.group) && this.name.equals(slotType.name);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name);
    }

    public String getId() {
        return this.group + "/" + this.name;
    }
}

