/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/class_1799;method_57363(Ljava/util/function/Consumer;Lnet/minecraft/class_10712;Lnet/minecraft/class_1657;)V", shift=At.Shift.BEFORE)}, method={"method_67194(Lnet/minecraft/class_1792$class_9635;Lnet/minecraft/class_10712;Lnet/minecraft/class_1657;Lnet/minecraft/class_1836;Ljava/util/function/Consumer;)V"})
    private void getTooltip(class_1792.class_9635 context, class_10712 displayComponent, class_1657 player, class_1836 type, Consumer<class_2561> textConsumer, CallbackInfo ci) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(comp -> {
            class_1799 self = (class_1799)this;
            boolean showAttributeTooltip = displayComponent.method_67214(TrinketsAttributeModifiersComponent.TYPE);
            if (!showAttributeTooltip) {
                return;
            }
            boolean canEquipAnywhere = true;
            HashSet slots = Sets.newHashSet();
            HashMap modifiers = Maps.newHashMap();
            Multimap<class_6880<class_1320>, class_1322> defaultModifier = null;
            boolean allModifiersSame = true;
            int slotCount = 0;
            for (Map.Entry<String, Map<String, TrinketInventory>> entry : comp.getInventory().entrySet()) {
                block1: for (Map.Entry<String, TrinketInventory> inventory : entry.getValue().entrySet()) {
                    TrinketInventory trinketInventory = inventory.getValue();
                    SlotType slotType = trinketInventory.getSlotType();
                    ++slotCount;
                    boolean anywhereButHidden = false;
                    for (int i = 0; i < trinketInventory.method_5439(); ++i) {
                        SlotReference ref = new SlotReference(trinketInventory, i);
                        boolean res = TrinketsApi.evaluatePredicateSet(slotType.getTooltipPredicates(), self, ref, (class_1309)player);
                        boolean canInsert = TrinketSlot.canInsert(self, ref, (class_1309)player);
                        if (res && canInsert) {
                            boolean sameTranslationExists = false;
                            for (SlotType t : slots) {
                                if (!t.getTranslation().getString().equals(slotType.getTranslation().getString())) continue;
                                sameTranslationExists = true;
                                break;
                            }
                            if (!sameTranslationExists) {
                                slots.add(slotType);
                            }
                            Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(self, ref, (class_1309)player);
                            if (defaultModifier == null) {
                                defaultModifier = map;
                            } else if (allModifiersSame) {
                                allModifiersSame = this.areMapsEqual(defaultModifier, map);
                            }
                            boolean duplicate = false;
                            for (Map.Entry entry2 : modifiers.entrySet()) {
                                if (!((SlotType)entry2.getKey()).getTranslation().getString().equals(slotType.getTranslation().getString()) || !this.areMapsEqual((Multimap<class_6880<class_1320>, class_1322>)((Multimap)entry2.getValue()), map)) continue;
                                duplicate = true;
                                break;
                            }
                            if (duplicate) continue block1;
                            modifiers.put(slotType, map);
                            continue block1;
                        }
                        if (!canInsert) continue;
                        anywhereButHidden = true;
                    }
                    if (anywhereButHidden) continue;
                    canEquipAnywhere = false;
                }
            }
            if (canEquipAnywhere && slotCount > 1) {
                textConsumer.accept((class_2561)class_2561.method_43471((String)"trinkets.tooltip.slots.any").method_27692(class_124.field_1080));
            } else if (slots.size() > 1) {
                textConsumer.accept((class_2561)class_2561.method_43471((String)"trinkets.tooltip.slots.list").method_27692(class_124.field_1080));
                for (SlotType slotType : slots) {
                    textConsumer.accept((class_2561)slotType.getTranslation().method_27692(class_124.field_1078));
                }
            } else if (slots.size() == 1) {
                for (SlotType slotType : slots) {
                    textConsumer.accept((class_2561)class_2561.method_43469((String)"trinkets.tooltip.slots.single", (Object[])new Object[]{slotType.getTranslation().method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
                }
            }
            if (!modifiers.isEmpty() && showAttributeTooltip) {
                if (allModifiersSame) {
                    if (defaultModifier != null && !defaultModifier.isEmpty()) {
                        textConsumer.accept((class_2561)class_2561.method_43471((String)"trinkets.tooltip.attributes.all").method_27692(class_124.field_1080));
                        this.addAttributes(textConsumer, defaultModifier);
                    }
                } else {
                    for (Map.Entry<String, Map<String, TrinketInventory>> entry : modifiers.entrySet()) {
                        textConsumer.accept((class_2561)class_2561.method_43469((String)"trinkets.tooltip.attributes.single", (Object[])new Object[]{((SlotType)((Object)entry.getKey())).getTranslation().method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
                        this.addAttributes(textConsumer, (Multimap<class_6880<class_1320>, class_1322>)((Multimap)entry.getValue()));
                    }
                }
            }
        });
    }

    @Unique
    private void addAttributes(Consumer<class_2561> textConsumer, Multimap<class_6880<class_1320>, class_1322> map) {
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entries()) {
                class_6880 attribute = (class_6880)entry.getKey();
                class_1322 modifier = (class_1322)entry.getValue();
                double g = modifier.comp_2449();
                if (modifier.comp_2450() != class_1322.class_1323.field_6330 && modifier.comp_2450() != class_1322.class_1323.field_6331) {
                    if (((class_6880)entry.getKey()).equals((Object)class_5134.field_23718)) {
                        g *= 10.0;
                    }
                } else {
                    g *= 100.0;
                }
                class_5250 text = class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
                if (attribute.method_40227() && attribute.comp_349() instanceof SlotAttributes.SlotEntityAttribute) {
                    text = class_2561.method_43469((String)"trinkets.tooltip.attributes.slots", (Object[])new Object[]{text});
                }
                if (g > 0.0) {
                    textConsumer.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(g), text}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(g < 0.0)) continue;
                textConsumer.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(g *= -1.0), text}).method_27692(class_124.field_1061));
            }
        }
    }

    @Unique
    private boolean areMapsEqual(Multimap<class_6880<class_1320>, class_1322> map1, Multimap<class_6880<class_1320>, class_1322> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (class_6880 attribute : map1.keySet()) {
            if (!map2.containsKey((Object)attribute)) {
                return false;
            }
            Collection col1 = map1.get((Object)attribute);
            Collection col2 = map2.get((Object)attribute);
            if (col1.size() != col2.size()) {
                return false;
            }
            Iterator iter = col2.iterator();
            for (class_1322 modifier : col1) {
                class_1322 eam = (class_1322)iter.next();
                if (!modifier.comp_2450().equals((Object)eam.comp_2450())) {
                    return false;
                }
                if (modifier.comp_2449() == eam.comp_2449()) continue;
                return false;
            }
        }
        return true;
    }
}

