package dev.emi.trinkets;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1735;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_768;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketsApi;

public class TrinketScreenManager {
	private static final class_2960 MORE_SLOTS = class_2960.method_60655("trinkets", "textures/gui/more_slots.png");
	private static WeakReference<TrinketScreen> currentScreen;
	public static class_768 currentBounds = new class_768(0, 0, 0, 0);
	public static class_768 typeBounds = new class_768(0, 0, 0, 0);
	public static class_768 quickMoveBounds = new class_768(0, 0, 0, 0);
	public static class_768 quickMoveTypeBounds = new class_768(0, 0, 0, 0);
	public static SlotGroup group = null;
	public static SlotGroup quickMoveGroup = null;

	public static void init(TrinketScreen screen) {
		currentScreen = new WeakReference<>(screen);
		group = null;
		currentBounds = new class_768(0, 0, 0, 0);
	}

	public static void close() {
		init(null);
	}

	public static void removeSelections() {
		TrinketsClient.activeGroup = null;
		TrinketsClient.quickMoveGroup = null;
	}

	public static void update(float mouseX, float mouseY) {
		TrinketScreen currentScreen = getCurrentScreen();
		if (currentScreen == null) {
			return;
		}

		TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
		class_1735 focusedSlot = currentScreen.trinkets$getFocusedSlot();
		int x = currentScreen.trinkets$getX();
		int y = currentScreen.trinkets$getY();
		if (group != null) {
			if (TrinketsClient.activeType != null) {
				if (!typeBounds.method_3318(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
					TrinketsClient.activeType = null;
				} else if (focusedSlot != null) {
					if (!(focusedSlot instanceof TrinketSlot ts && ts.getType() == TrinketsClient.activeType)) {
						TrinketsClient.activeType = null;
					}
				}
			}
			if (TrinketsClient.activeType == null) {
				if (!currentBounds.method_3318(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
					TrinketsClient.activeGroup = null;
					group = null;
				} else {
					if (focusedSlot instanceof TrinketSlot ts) {
						int i = handler.trinkets$getSlotTypes(group).indexOf(ts.getType());
						if (i >= 0) {
							Point slotHeight = handler.trinkets$getSlotHeight(group, i);
							if (slotHeight != null) {
								class_768 r = currentScreen.trinkets$getGroupRect(group);
								int height = slotHeight.y();
								if (height > 1) {
									TrinketsClient.activeType = ts.getType();
									typeBounds = new class_768(r.method_3321() + slotHeight.x() - 2, r.method_3322() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
								}
							}
						}
					}
				}
			}
		}

		if (group == null && quickMoveGroup != null) {
			if (quickMoveTypeBounds.method_3318(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
				TrinketsClient.activeGroup = quickMoveGroup;
				TrinketsClient.activeType = TrinketsClient.quickMoveType;
				int i = handler.trinkets$getSlotTypes(TrinketsClient.activeGroup).indexOf(TrinketsClient.activeType);
				if (i >= 0) {
					Point slotHeight = handler.trinkets$getSlotHeight(TrinketsClient.activeGroup, i);
					if (slotHeight != null) {
						class_768 r = currentScreen.trinkets$getGroupRect(TrinketsClient.activeGroup);
						int height = slotHeight.y();
						if (height > 1) {
							typeBounds = new class_768(r.method_3321() + slotHeight.x() - 2, r.method_3322() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
						}
					}
				}
				TrinketsClient.quickMoveGroup = null;
			} else if (quickMoveBounds.method_3318(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
				TrinketsClient.activeGroup = quickMoveGroup;
				TrinketsClient.quickMoveGroup = null;
			}
		}

		if (group == null) {
			class_310 client = class_310.method_1551();
			for (SlotGroup g : TrinketsApi.getPlayerSlots(client.field_1724).values()) {
				class_768 r = currentScreen.trinkets$getGroupRect(g);
				if (r.method_3321() < 0 && currentScreen.trinkets$isRecipeBookOpen()) {
					continue;
				}
				if (r.method_3318(Math.round(mouseX) - x, Math.round(mouseY) - y)) {
					TrinketsClient.activeGroup = g;
					TrinketsClient.quickMoveGroup = null;
					break;
				}
			}
		}

		if (group != TrinketsClient.activeGroup) {
			group = TrinketsClient.activeGroup;

			if (group != null) {
				int slotsWidth = handler.trinkets$getSlotWidth(group) + 1;
				if (group.getSlotId() == -1) slotsWidth -= 1;
				class_768 r = currentScreen.trinkets$getGroupRect(group);
				currentBounds = new class_768(0, 0, 0, 0);

				if (r != null) {
					int l = (slotsWidth - 1) / 2 * 18;

					if (slotsWidth > 1) {
						currentBounds = new class_768(r.method_3321() - l - 3, r.method_3322() - 3, slotsWidth * 18 + 5, 23);
					} else {
						currentBounds = r;
					}

					if (focusedSlot instanceof TrinketSlot ts) {
						int i = handler.trinkets$getSlotTypes(group).indexOf(ts.getType());
						if (i >= 0) {
							Point slotHeight = handler.trinkets$getSlotHeight(group, i);
							if (slotHeight != null) {
								int height = slotHeight.y();
								if (height > 1) {
									TrinketsClient.activeType = ts.getType();
									typeBounds = new class_768(r.method_3321() + slotHeight.x() - 2, r.method_3322() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
								}
							}
						}
					}
				}
			}
		}

		if (quickMoveGroup != TrinketsClient.quickMoveGroup) {
			quickMoveGroup = TrinketsClient.quickMoveGroup;

			if (quickMoveGroup != null) {
				int slotsWidth = handler.trinkets$getSlotWidth(quickMoveGroup) + 1;

				if (quickMoveGroup.getSlotId() == -1) slotsWidth -= 1;
				class_768 r = currentScreen.trinkets$getGroupRect(quickMoveGroup);
				quickMoveBounds = new class_768(0, 0, 0, 0);

				if (r != null) {
					int l = (slotsWidth - 1) / 2 * 18;
					quickMoveBounds = new class_768(r.method_3321() - l - 5, r.method_3322() - 5, slotsWidth * 18 + 8, 26);
					if (TrinketsClient.quickMoveType != null) {
						int i = handler.trinkets$getSlotTypes(quickMoveGroup).indexOf(TrinketsClient.quickMoveType);
						if (i >= 0) {
							Point slotHeight = handler.trinkets$getSlotHeight(quickMoveGroup, i);
							if (slotHeight != null) {
								int height = slotHeight.y();
								quickMoveTypeBounds = new class_768(r.method_3321() + slotHeight.x() - 2, r.method_3322() - (height - 1) / 2 * 18 - 3, 23, height * 18 + 5);
							}
						}
					}
				}
			}
		}
	}

	public static void tick() {
		if (TrinketsClient.quickMoveTimer > 0) {
			TrinketsClient.quickMoveTimer--;

			if (TrinketsClient.quickMoveTimer <= 0) {
				TrinketsClient.quickMoveGroup = null;
			}
		}
	}

	public static void drawGroup(class_332 context, SlotGroup group, SlotType type) {
		TrinketScreen currentScreen = getCurrentScreen();
		if (currentScreen == null) {
			return;
		}

		TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
		context.method_51448().pushMatrix();
		class_768 r = currentScreen.trinkets$getGroupRect(group);
		int slotsWidth = handler.trinkets$getSlotWidth(group) + 1;
		List<Point> slotHeights = handler.trinkets$getSlotHeights(group);
		List<SlotType> slotTypes = handler.trinkets$getSlotTypes(group);
		if (group.getSlotId() == -1) slotsWidth -= 1;
		int x = r.method_3321() - 4 - (slotsWidth - 1) / 2 * 18;
		int y = r.method_3322() - 4;
		if (slotsWidth > 1 || type != null) {
			drawTexture(context, MORE_SLOTS, x, y, 0, 0, 4, 26);

			for (int i = 0; i < slotsWidth; i++) {
				drawTexture(context, MORE_SLOTS, x + i * 18 + 4, y, 4, 0, 18, 26);
			}

			drawTexture(context, MORE_SLOTS, x + slotsWidth * 18 + 4, y, 22, 0, 4, 26);
			for (int s = 0; s < slotHeights.size() && s < slotTypes.size(); s++) {
				if (slotTypes.get(s) != type) {
					continue;
				}
				Point slotHeight = slotHeights.get(s);
				int height = slotHeight.y();
				if (height > 1) {
					int top = (height - 1) / 2;
					int bottom = height / 2;
					int slotX = slotHeight.x() - 4 + r.method_3321();
					if (height > 2) {
						drawTexture(context, MORE_SLOTS, slotX, y - top * 18, 0, 0, 26, 4);
					}

					for (int i = 1; i < top + 1; i++) {
						drawTexture(context, MORE_SLOTS, slotX, y - i * 18 + 4, 0, 4, 26, 18);
					}

					for (int i = 1; i < bottom + 1; i++) {
						drawTexture(context, MORE_SLOTS, slotX, y + i * 18 + 4, 0, 4, 26, 18);
					}

					drawTexture(context, MORE_SLOTS, slotX, y + 18 + bottom * 18 + 4, 0, 22, 26, 4);
				}
			}


			// The rest of this is just to re-render a portion of the top and bottom slot borders so that corners
			// between slot types on the GUI look nicer
			for (int s = 0; s < slotHeights.size(); s++) {
				Point slotHeight = slotHeights.get(s);
				int height = slotHeight.y();
				if (slotTypes.get(s) != type) {
					height = 1;
				}
				int slotX = slotHeight.x() + r.method_3321() + 1;
				int top = (height - 1) / 2;
				int bottom = height / 2;
				drawTexture(context, MORE_SLOTS, slotX, y - top * 18 + 1, 4, 1, 16, 3);
				drawTexture(context, MORE_SLOTS, slotX, y + (bottom + 1) * 18 + 4, 4, 22, 16, 3);
			}

			// Because pre-existing slots are not part of the slotHeights list
			if (group.getSlotId() != -1) {
				drawTexture(context, MORE_SLOTS, r.method_3321() + 1, y + 1, 4, 1, 16, 3);
				drawTexture(context, MORE_SLOTS, r.method_3321() + 1, y + 22, 4, 22, 16, 3);
			}
		} else {
			drawTexture(context, MORE_SLOTS, x + 4, y + 4, 4, 4, 18, 18);
		}

		context.method_51448().popMatrix();
	}

	private static void drawTexture(class_332 context, class_2960 texture, int x, int y, int u, int v, int width, int height) {
		context.method_25290(class_10799.field_56883, texture,  x, y, u, v, width, height, 256, 256);
	}

	public static void drawActiveGroup(class_332 context) {
		if (TrinketsClient.activeGroup != null) {
			TrinketScreenManager.drawGroup(context, TrinketsClient.activeGroup, TrinketsClient.activeType);
		} else if (TrinketsClient.quickMoveGroup != null) {
			TrinketScreenManager.drawGroup(context, TrinketsClient.quickMoveGroup, TrinketsClient.quickMoveType);
		}
	}

	public static void drawExtraGroups(class_332 context) {
		TrinketScreen currentScreen = getCurrentScreen();
		if (currentScreen == null) {
			return;
		}

		TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
		int x = currentScreen.trinkets$getX();
		int y = currentScreen.trinkets$getY();
		int groupCount = handler.trinkets$getGroupCount();
		if (groupCount <= 0 || currentScreen.trinkets$isRecipeBookOpen()) {
			return;
		}
		int width = groupCount / 4;
		int height = groupCount % 4;
		if (height == 0) {
			height = 4;
			width--;
		}
		drawTexture(context, MORE_SLOTS, x + 3, y,      7, 26, 1, 7);
		// Repeated tops and bottoms
		for (int i = 0; i < width; i++) {
			drawTexture(context, MORE_SLOTS, x - 15 - 18 * i, y,      7, 26, 18, 7);
			drawTexture(context, MORE_SLOTS, x - 15 - 18 * i, y + 79, 7, 51, 18, 7);
		}
		// Top and bottom
		drawTexture(context, MORE_SLOTS, x - 15 - 18 * width, y,                   7, 26, 18, 7);
		drawTexture(context, MORE_SLOTS, x - 15 - 18 * width, y + 7 + 18 * height, 7, 51, 18, 7);
		// Corners
		drawTexture(context, MORE_SLOTS, x - 22 - 18 * width, y,                   0, 26, 7, 7);
		drawTexture(context, MORE_SLOTS, x - 22 - 18 * width, y + 7 + 18 * height, 0, 51, 7, 7);
		// Outer sides
		for (int i = 0; i < height; i++) {
			drawTexture(context, MORE_SLOTS, x - 22 - 18 * width, y + 7 + 18 * i, 0, 34, 7, 18);
		}
		// Inner sides
		if (width > 0) {
			for (int i = height; i < 4; i++) {
				drawTexture(context, MORE_SLOTS, x - 4 - 18 * width, y + 7 + 18 * i, 0, 34, 7, 18);
			}
		}
		if (width > 0 && height < 4) {
			// Bottom corner
			drawTexture(context, MORE_SLOTS, x - 4 - 18 * width, y + 79, 0, 51, 7, 7);
			// Inner corner
			drawTexture(context, MORE_SLOTS, x - 4 - 18 * width, y + 7 + 18 * height, 0, 58, 7, 7);
		}
		if (width > 0 || height == 4) {
			// Inner corner
			drawTexture(context, MORE_SLOTS, x, y + 79, 0, 58, 3, 7);
		}
	}

	public static boolean isClickInsideTrinketBounds(double mouseX, double mouseY) {
		TrinketScreen currentScreen = getCurrentScreen();
		if (currentScreen == null || class_310.method_1551().field_1755 != currentScreen) {
			return false;
		}

		TrinketPlayerScreenHandler handler = currentScreen.trinkets$getHandler();
		int x = currentScreen.trinkets$getX();
		int y = currentScreen.trinkets$getY();
		int mx = (int) (Math.round(mouseX) - x);
		int my = (int) (Math.round(mouseY) - y);
		if (TrinketScreenManager.currentBounds.method_3318(mx, my)) {
			return true;
		}
		int groupCount = handler.trinkets$getGroupCount();
		if (groupCount <= 0 || currentScreen.trinkets$isRecipeBookOpen()) {
			return false;
		}
		int width = groupCount / 4;
		int height = groupCount % 4;
		if (width > 0) {
			if (new class_768(-4 - 18 * width, 0, 7 + 18 * width, 86).method_3318(mx, my)) {
				return true;
			}
		}
		if (height > 0) {
			if (new class_768(-22 - 18 * width, 0, 25, 14 + 18 * height).method_3318(mx, my)) {
				return true;
			}
		}
		return false;
	}

	static void tryUpdateTrinketsSlot() {
		TrinketScreen currentScreen = getCurrentScreen();

		if (currentScreen != null) {
			currentScreen.trinkets$updateTrinketSlots();
		}
	}

	private static TrinketScreen getCurrentScreen() {
		if (currentScreen == null) {
			return null;
		}
		return currentScreen.get();
	}
}
