package dev.emi.trinkets.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import com.mojang.serialization.DynamicOps;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.entity.RespawnableComponent;

public class LivingEntityTrinketComponent implements TrinketComponent, AutoSyncedComponent, RespawnableComponent {

	public Map<String, Map<String, TrinketInventory>> inventory = new HashMap<>();
	public Set<TrinketInventory> trackingUpdates = new HashSet<>();
	public Map<String, SlotGroup> groups = new HashMap<>();
	public int size;
	public class_1309 entity;
	private boolean syncing;

	public LivingEntityTrinketComponent(class_1309 entity) {
		this.entity = entity;
		this.update();
	}

	@Override
	public class_1309 getEntity() {
		return this.entity;
	}

	@Override
	public Map<String, SlotGroup> getGroups() {
		return this.groups;
	}

	@Override
	public Map<String, Map<String, TrinketInventory>> getInventory() {
		return inventory;
	}

	@Override
	public void update() {
		Map<String, SlotGroup> entitySlots = TrinketsApi.getEntitySlots(this.entity);
		int count = 0;
		groups.clear();
		Map<String, Map<String, TrinketInventory>> inventory = new HashMap<>();
		for (Map.Entry<String, SlotGroup> group : entitySlots.entrySet()) {
			String groupKey = group.getKey();
			SlotGroup groupValue = group.getValue();
			Map<String, TrinketInventory> oldGroup = this.inventory.get(groupKey);
			groups.put(groupKey, groupValue);
			for (Map.Entry<String, SlotType> slot : groupValue.getSlots().entrySet()) {
				TrinketInventory inv = new TrinketInventory(slot.getValue(), this, e -> this.trackingUpdates.add(e));
				if (oldGroup != null) {
					TrinketInventory oldInv = oldGroup.get(slot.getKey());
					if (oldInv != null) {
						inv.copyFrom(oldInv);
						for (int i = 0; i < oldInv.method_5439(); i++) {
							class_1799 stack = oldInv.method_5438(i).method_7972();
							if (i < inv.method_5439()) {
								inv.method_5447(i, stack);
							} else {
								if (this.entity instanceof class_1657 player) {
									player.method_31548().method_7398(stack);
								} else if (this.entity.method_37908() instanceof class_3218 serverWorld) {
									this.entity.method_5775(serverWorld, stack);
								}
							}
						}
					}
				}
				inventory.computeIfAbsent(group.getKey(), (k) -> new HashMap<>()).put(slot.getKey(), inv);
				count += inv.method_5439();
			}
		}
		size = count;
		this.inventory = inventory;
	}

	@Override
	public void clearCachedModifiers() {
		for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
			for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
				slotType.getValue().clearCachedModifiers();
			}
		}
	}

	@Override
	public Set<TrinketInventory> getTrackingUpdates() {
		return this.trackingUpdates;
	}

	@Override
	public void addTemporaryModifiers(Multimap<String, class_1322> modifiers) {
		for (Map.Entry<String, Collection<class_1322>> entry : modifiers.asMap().entrySet()) {
			String[] keys = entry.getKey().split("/");
			String group = keys[0];
			String slot = keys[1];
			for (class_1322 modifier : entry.getValue()) {
				Map<String, TrinketInventory> groupInv = this.inventory.get(group);
				if (groupInv != null) {
					TrinketInventory inv = groupInv.get(slot);
					if (inv != null) {
						inv.addModifier(modifier);
					}
				}
			}
		}
	}

	@Override
	public void addPersistentModifiers(Multimap<String, class_1322> modifiers) {
		for (Map.Entry<String, Collection<class_1322>> entry : modifiers.asMap().entrySet()) {
			String[] keys = entry.getKey().split("/");
			String group = keys[0];
			String slot = keys[1];
			for (class_1322 modifier : entry.getValue()) {
				Map<String, TrinketInventory> groupInv = this.inventory.get(group);
				if (groupInv != null) {
					TrinketInventory inv = groupInv.get(slot);
					if (inv != null) {
						inv.addPersistentModifier(modifier);
					}
				}
			}
		}
	}

	@Override
	public void removeModifiers(Multimap<String, class_1322> modifiers) {
		for (Map.Entry<String, Collection<class_1322>> entry : modifiers.asMap().entrySet()) {
			String[] keys = entry.getKey().split("/");
			String group = keys[0];
			String slot = keys[1];
			for (class_1322 modifier : entry.getValue()) {
				Map<String, TrinketInventory> groupInv = this.inventory.get(group);
				if (groupInv != null) {
					TrinketInventory inv = groupInv.get(slot);
					if (inv != null) {
						inv.removeModifier(modifier.comp_2447());
					}
				}
			}
		}
	}

	@Override
	public Multimap<String, class_1322> getModifiers() {
		Multimap<String, class_1322> result = HashMultimap.create();
		for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
			for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
				result.putAll(group.getKey() + "/" + slotType.getKey(), slotType.getValue().getModifiers().values());
			}
		}

		return result;
	}

	@Override
	public void clearModifiers() {
		for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
			for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
				slotType.getValue().clearModifiers();
			}
		}
	}

	@Override
	public void readData(class_11368 view) {
		Optional<TrinketSaveData> optional = view.method_71418(TrinketSaveData.MAP_CODEC);
		class_2371<class_1799> dropped = class_2371.method_10211();
		if (optional.isPresent()) {
			TrinketSaveData data = optional.orElseThrow();
			for (String groupKey : data.data().keySet()) {
				Map<String, TrinketSaveData.InventoryData> groupTag = data.data().get(groupKey);
				if (groupTag != null) {
					Map<String, TrinketInventory> groupSlots = this.inventory.get(groupKey);
					if (groupSlots != null) {
						for (String slotKey : groupTag.keySet()) {
							TrinketSaveData.InventoryData slotTag = groupTag.get(slotKey);
							TrinketInventory inv = groupSlots.get(slotKey);

							if (inv != null) {
								inv.fromMetadata(slotTag.metadata());
							}

							for (int i = 0; i < slotTag.items().size(); i++) {
								class_1799 stack = slotTag.items().get(i);
								if (inv != null && i < inv.method_5439()) {
									inv.method_5447(i, stack);
								} else {
									dropped.add(stack);
								}
							}
						}
					} else {
						for (String slotKey : groupTag.keySet()) {
							dropped.addAll(groupTag.get(slotKey).items());
						}
					}
				}
			}
		}
		if (this.entity.method_37908() instanceof class_3218 serverWorld) {
			for (class_1799 itemStack : dropped) {
				this.entity.method_5775(serverWorld, itemStack);
			}
		}
		Multimap<String, class_1322> slotMap = HashMultimap.create();
		this.forEach((ref, stack) -> {
			if (!stack.method_7960()) {
				Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(stack, ref, entity);
				for (class_6880<class_1320> entityAttribute : map.keySet()) {
					if (entityAttribute.method_40227() && entityAttribute.comp_349() instanceof SlotAttributes.SlotEntityAttribute slotEntityAttribute) {
						slotMap.putAll(slotEntityAttribute.slot, map.get(entityAttribute));
					}
				}
			}
		});
		for (Map.Entry<String, Map<String, TrinketInventory>> groupEntry : this.getInventory().entrySet()) {
			for (Map.Entry<String, TrinketInventory> slotEntry : groupEntry.getValue().entrySet()) {
				String group = groupEntry.getKey();
				String slot = slotEntry.getKey();
				String key = group + "/" + slot;
				Collection<class_1322> modifiers = slotMap.get(key);
				TrinketInventory inventory = slotEntry.getValue();
				for (class_1322 modifier : modifiers) {
					inventory.removeCachedModifier(modifier);
				}
				inventory.clearCachedModifiers();
			}
		}
	}

	@Override
	public void applySyncPacket(class_9129 buf) {
		class_2487 tag = buf.method_10798();

		if (tag != null) {
			DynamicOps<class_2520> ops = buf.method_56349().method_57093(class_2509.field_11560);
			for (String groupKey : tag.method_10541()) {
				class_2487 groupTag = tag.method_68568(groupKey);
				if (groupTag != null) {
					Map<String, TrinketInventory> groupSlots = this.inventory.get(groupKey);
					if (groupSlots != null) {
						for (String slotKey : groupTag.method_10541()) {
							class_2487 slotTag = groupTag.method_68568(slotKey);
							class_2499 list = slotTag.method_68569("Items");
							TrinketInventory inv = groupSlots.get(slotKey);

							if (inv != null) {
								inv.applySyncMetadata(slotTag.method_67492("Metadata", TrinketSaveData.Metadata.CODEC, ops).orElse(TrinketSaveData.Metadata.EMPTY));
							}

							for (int i = 0; i < list.size(); i++) {
								class_2487 c = list.method_68582(i);
								class_1799 stack = class_1799.field_49266.decode(ops, c).result().map(com.mojang.datafixers.util.Pair::getFirst).orElse(class_1799.field_8037);
								if (inv != null && i < inv.method_5439()) {
									inv.method_5447(i, stack);
								}
							}
						}
					}
				}
			}

			if (this.entity instanceof class_1657 player) {
				((TrinketPlayerScreenHandler) player.field_7498).trinkets$updateTrinketSlots(false);
			}
		}
	}

	@Override
	public void writeData(class_11372 view) {
		TrinketSaveData data = new TrinketSaveData(new HashMap<>());
		for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
			Map<String, TrinketSaveData.InventoryData> groupTag = new HashMap<>();
			for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
				TrinketInventory inv = slot.getValue();

				List<class_1799> items = new ArrayList<>();
				for (int i = 0; i < inv.method_5439(); i++) {
					items.add(inv.method_5438(i).method_7972());
				}
				TrinketSaveData.Metadata metadata = this.syncing ? inv.getSyncMetadata() : inv.toMetadata();
				groupTag.put(slot.getKey(), new TrinketSaveData.InventoryData(metadata, items));
			}
			data.data().put(group.getKey(), groupTag);
		}
		view.method_71460(TrinketSaveData.MAP_CODEC, data);
	}

	@Override
	public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
		this.syncing = true;
		class_11362 tag = class_11362.method_71458(class_8942.field_60348);
		this.writeData(tag);
		this.syncing = false;
		buf.method_10794(tag.method_71475());
	}

	@Override
	public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory, boolean sameCharacter) {
		return lossless || keepInventory;
	}

	@Override
	public boolean isEquipped(Predicate<class_1799> predicate) {
		for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
			for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
				TrinketInventory inv = slotType.getValue();
				for (int i = 0; i < inv.method_5439(); i++) {
					if (predicate.test(inv.method_5438(i))) {
						return true;
					}
				}
			}
		}
		return false;
	}

	@Override
	public List<class_3545<SlotReference, class_1799>> getEquipped(Predicate<class_1799> predicate) {
		List<class_3545<SlotReference, class_1799>> list = new ArrayList<>();
		forEach((slotReference, itemStack) -> {
			if (predicate.test(itemStack)) {
				list.add(new class_3545<>(slotReference, itemStack));
			}
		});
		return list;
	}

	@Override
	public void forEach(BiConsumer<SlotReference, class_1799> consumer) {
		for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
			for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
				TrinketInventory inv = slotType.getValue();
				for (int i = 0; i < inv.method_5439(); i++) {
					consumer.accept(new SlotReference(inv, i), inv.method_5438(i));
				}
			}
		}
	}
}