package dev.emi.trinkets.api;

import java.util.Map;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;

public class SlotAttributes {
	private static final Map<String, class_2960> CACHED_IDS = Maps.newHashMap();
	private static final Map<String, class_6880<class_1320>> CACHED_ATTRIBUTES = Maps.newHashMap();

	/**
	 * Adds an Entity Attribute Modifier for slot count to the provided multimap
	 */
	public static void addSlotModifier(Multimap<class_6880<class_1320>, class_1322> map, String slot, class_2960 identifier, double amount,
			class_1322.class_1323 operation) {
		CACHED_ATTRIBUTES.putIfAbsent(slot, class_6880.method_40223(new SlotEntityAttribute(slot)));
		map.put(CACHED_ATTRIBUTES.get(slot), new class_1322(identifier, amount, operation));
	}

	public static class_2960 getIdentifier(SlotReference ref) {
		String key = ref.getId();
		return CACHED_IDS.computeIfAbsent(key, class_2960::method_60654);
	}

	public static class SlotEntityAttribute extends class_1320 {
		public String slot;

		private SlotEntityAttribute(String slot) {
			super("trinkets.slot." + slot.replace("/", "."), 0);
			this.slot = slot;
		}
	}
}