package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function3;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketSlotTarget;
import dev.emi.trinkets.TrinketsMain;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.payload.BreakPayload;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistryV3;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class TrinketsApi {
	public static final ComponentKey<TrinketComponent> TRINKET_COMPONENT = ComponentRegistryV3.INSTANCE
			.getOrCreate(class_2960.method_60655(TrinketsMain.MOD_ID, "trinkets"), TrinketComponent.class);
	private static final Map<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>> PREDICATES = new HashMap<>();

	private static final Map<class_1792, Trinket> TRINKETS = new HashMap<>();
	private static final Trinket DEFAULT_TRINKET;

	/**
	 * Registers a trinket for the provided item, {@link TrinketItem} will do this
	 * automatically.
	 */
	public static void registerTrinket(class_1792 item, Trinket trinket) {
		TRINKETS.put(item, trinket);
	}

	public static Trinket getTrinket(class_1792 item) {
		return TRINKETS.getOrDefault(item, DEFAULT_TRINKET);
	}

	public static Trinket getDefaultTrinket() {
		return DEFAULT_TRINKET;
	}

	/**
	 * @return The trinket component for this entity, if available
	 */
	public static Optional<TrinketComponent> getTrinketComponent(class_1309 livingEntity) {
		return TRINKET_COMPONENT.maybeGet(livingEntity);
	}

	/**
	 * Called to sync a trinket breaking event with clients. Should generally be
	 * called in the callback of {@link class_1799#method_7956(int, class_3218, class_3222, Consumer)}
	 */
	public static void onTrinketBroken(class_1799 stack, SlotReference ref, class_1309 entity) {
		class_1937 world = entity.method_37908();
		if (!world.field_9236) {
			BreakPayload packet = new BreakPayload(entity.method_5628(), ref.inventory().getSlotType().getGroup(), ref.inventory().getSlotType().getName(), ref.index());
			if (entity instanceof class_3222 player) {
				ServerPlayNetworking.send(player, packet);
			}
			PlayerLookup.tracking(entity).forEach(watcher -> {
				ServerPlayNetworking.send(watcher, packet);
			});
		}
	}

	/**
	 * @deprecated Use world-sensitive alternative {@link TrinketsApi#getPlayerSlots(class_1937)}
	 * @return A map of slot group names to slot groups available for players
	 */
	@Deprecated
	public static Map<String, SlotGroup> getPlayerSlots() {
		return getEntitySlots(class_1299.field_6097);
	}

	/**
	 * @return A sided map of slot group names to slot groups available for players
	 */
	public static Map<String, SlotGroup> getPlayerSlots(class_1937 world) {
		return getEntitySlots(world, class_1299.field_6097);
	}

	/**
	 * @return A sided map of slot group names to slot groups available for players
	 */
	public static Map<String, SlotGroup> getPlayerSlots(class_1657 player) {
		return getEntitySlots(player);
	}

	/**
	 * @deprecated Use world-sensitive alternative {@link TrinketsApi#getEntitySlots(class_1937, class_1299)}
	 * @return A map of slot group names to slot groups available for the provided
	 * entity type
	 */
	@Deprecated
	public static Map<String, SlotGroup> getEntitySlots(class_1299<?> type) {
		EntitySlotLoader loader = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
		return loader.getEntitySlots(type);
	}

	/**
	 * @return A sided map of slot group names to slot groups available for the provided
	 * entity type
	 */
	public static Map<String, SlotGroup> getEntitySlots(class_1937 world, class_1299<?> type) {
		EntitySlotLoader loader = world.method_8608() ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
		return loader.getEntitySlots(type);
	}

	/**
	 * @return A sided map of slot group names to slot groups available for the provided
	 * entity
	 */
	public static Map<String, SlotGroup> getEntitySlots(class_1297 entity) {
		if (entity != null) {
			return getEntitySlots(entity.method_37908(), entity.method_5864());
		}
		return ImmutableMap.of();
	}

	/**
	 * Registers a predicate to be referenced in slot data
	 */
	public static void registerTrinketPredicate(class_2960 id, Function3<class_1799, SlotReference, class_1309, TriState> predicate) {
		PREDICATES.put(id, predicate);
	}

	public static Optional<Function3<class_1799, SlotReference, class_1309, TriState>> getTrinketPredicate(class_2960 id) {
		return Optional.ofNullable(PREDICATES.get(id));
	}

	public static boolean evaluatePredicateSet(Set<class_2960> set, class_1799 stack, SlotReference ref, class_1309 entity) {
		TriState state = TriState.DEFAULT;
		for (class_2960 id : set) {
			Optional<Function3<class_1799, SlotReference, class_1309, TriState>> function = getTrinketPredicate(id);
			if (function.isPresent()) {
				state = function.get().apply(stack, ref, entity);
			}
			if (state != TriState.DEFAULT) {
				break;
			}
		}
		return state.get();
	}

	public static class_1887.class_9427 withTrinketSlots(class_1887.class_9427 definition, Set<String> slots) {
		class_1887.class_9427 def = new class_1887.class_9427(definition.comp_2506(), definition.comp_2507(), definition.comp_2508(), definition.comp_2509(),
				definition.comp_2510(), definition.comp_2511(), definition.comp_2512(), definition.comp_2513());

		((TrinketSlotTarget) (Object) def).trinkets$slots(slots);
		return def;
	}

	static {
		TrinketsApi.registerTrinketPredicate(class_2960.method_60655("trinkets", "all"), (stack, ref, entity) -> TriState.TRUE);
		TrinketsApi.registerTrinketPredicate(class_2960.method_60655("trinkets", "none"), (stack, ref, entity) -> TriState.FALSE);
		class_6862<class_1792> trinketsAll = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("trinkets", "all"));

		TrinketsApi.registerTrinketPredicate(class_2960.method_60655("trinkets", "tag"), (stack, ref, entity) -> {
			SlotType slot = ref.inventory().getSlotType();
			class_6862<class_1792> tag = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("trinkets", slot.getId()));

			if (stack.method_31573(tag) || stack.method_31573(trinketsAll)) {
				return TriState.TRUE;
			}
			return TriState.DEFAULT;
		});
		TrinketsApi.registerTrinketPredicate(class_2960.method_60655("trinkets", "relevant"), (stack, ref, entity) -> {
			Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(stack, ref, entity);
			if (!map.isEmpty()) {
				return TriState.TRUE;
			}
			return TriState.DEFAULT;
		});
		DEFAULT_TRINKET = new Trinket() {

		};
	}
}