package dev.emi.trinkets.mixin;


import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketSaveData;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import dev.emi.trinkets.payload.SyncInventoryPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Syncs slot data to player's client on login
 *
 * @author C4
 */
@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;onSpawn()V"), method = "onPlayerConnect")
	private void onPlayerConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
		EntitySlotLoader.SERVER.sync(player);
		((TrinketPlayerScreenHandler) player.field_7498).trinkets$updateTrinketSlots(false);
		TrinketsApi.getTrinketComponent(player).ifPresent(trinkets -> {
			Map<String, TrinketSaveData.Metadata> tag = new HashMap<>();
			Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();

			for (TrinketInventory trinketInventory : inventoriesToSend) {
				tag.put(trinketInventory.getSlotType().getId(), trinketInventory.getSyncMetadata());
			}
			ServerPlayNetworking.send(player, new SyncInventoryPayload(player.method_5628(), Map.of(), tag));
			inventoriesToSend.clear();
		});
	}
}