package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketSlot;
import net.minecraft.class_10260;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_10260.class)
public abstract class RecipeBookScreenMixin extends class_465<class_1729> {
    @Unique
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_TEXTURE = class_2960.method_60656("container/slot_highlight_front");

    public RecipeBookScreenMixin(class_1729 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }


    @Inject(at = @At("HEAD"), method = "isClickOutsideBounds", cancellable = true)
    private void isClickOutsideBounds(double mouseX, double mouseY, int left, int top, int button, CallbackInfoReturnable<Boolean> info) {
        if (TrinketScreenManager.isClickInsideTrinketBounds(mouseX, mouseY)) {
            info.setReturnValue(false);
        }
    }

    @Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/RecipeBookScreen;renderCursorStack(Lnet/minecraft/client/gui/DrawContext;II)V", shift = At.Shift.BEFORE),
            method = "render")
    private void drawForeground(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (((Object) this) instanceof class_490) {
            context.method_51448().pushMatrix();
            context.method_51448().translate(this.field_2776, this.field_2800);
            TrinketScreenManager.drawActiveGroup(context);

            for (class_1735 slot : this.field_2797.field_7761) {
                if (slot instanceof TrinketSlot trinketSlot && trinketSlot.renderAfterRegularSlots() && slot.method_7682()) {
                    this.method_2385(context, slot);
                    if (slot == this.field_2787 && slot.method_51306()) {
                        context.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_TEXTURE, this.field_2787.field_7873 - 4, this.field_2787.field_7872 - 4, 24, 24);
                    }
                }
            }
            context.method_51448().popMatrix();
        }
    }
}
