/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketSaveData;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.entity.RespawnableComponent;

public class LivingEntityTrinketComponent
implements TrinketComponent,
AutoSyncedComponent,
RespawnableComponent {
    public Map<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
    public Set<TrinketInventory> trackingUpdates = new HashSet<TrinketInventory>();
    public Map<String, SlotGroup> groups = new HashMap<String, SlotGroup>();
    public int size;
    public class_1309 entity;
    private boolean syncing;

    public LivingEntityTrinketComponent(class_1309 entity) {
        this.entity = entity;
        this.update();
    }

    @Override
    public class_1309 getEntity() {
        return this.entity;
    }

    @Override
    public Map<String, SlotGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Map<String, Map<String, TrinketInventory>> getInventory() {
        return this.inventory;
    }

    @Override
    public void update() {
        Map<String, SlotGroup> entitySlots = TrinketsApi.getEntitySlots((class_1297)this.entity);
        int count = 0;
        this.groups.clear();
        HashMap<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
        for (Map.Entry<String, SlotGroup> group : entitySlots.entrySet()) {
            String groupKey = group.getKey();
            SlotGroup groupValue = group.getValue();
            Map<String, TrinketInventory> oldGroup = this.inventory.get(groupKey);
            this.groups.put(groupKey, groupValue);
            for (Map.Entry<String, SlotType> slot : groupValue.getSlots().entrySet()) {
                TrinketInventory oldInv;
                TrinketInventory inv = new TrinketInventory(slot.getValue(), this, e -> this.trackingUpdates.add((TrinketInventory)e));
                if (oldGroup != null && (oldInv = oldGroup.get(slot.getKey())) != null) {
                    inv.copyFrom(oldInv);
                    for (int i = 0; i < oldInv.method_5439(); ++i) {
                        class_1799 stack = oldInv.method_5438(i).method_7972();
                        if (i < inv.method_5439()) {
                            inv.method_5447(i, stack);
                            continue;
                        }
                        class_1309 class_13092 = this.entity;
                        if (class_13092 instanceof class_1657) {
                            class_1657 player = (class_1657)class_13092;
                            player.method_31548().method_7398(stack);
                            continue;
                        }
                        class_13092 = this.entity.method_37908();
                        if (!(class_13092 instanceof class_3218)) continue;
                        class_3218 serverWorld = (class_3218)class_13092;
                        this.entity.method_5775(serverWorld, stack);
                    }
                }
                inventory.computeIfAbsent(group.getKey(), k -> new HashMap()).put(slot.getKey(), inv);
                count += inv.method_5439();
            }
        }
        this.size = count;
        this.inventory = inventory;
    }

    @Override
    public void clearCachedModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearCachedModifiers();
            }
        }
    }

    @Override
    public Set<TrinketInventory> getTrackingUpdates() {
        return this.trackingUpdates;
    }

    @Override
    public void addTemporaryModifiers(Multimap<String, class_1322> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (class_1322 modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addModifier(modifier);
            }
        }
    }

    @Override
    public void addPersistentModifiers(Multimap<String, class_1322> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (class_1322 modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addPersistentModifier(modifier);
            }
        }
    }

    @Override
    public void removeModifiers(Multimap<String, class_1322> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (class_1322 modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.removeModifier(modifier.comp_2447());
            }
        }
    }

    @Override
    public Multimap<String, class_1322> getModifiers() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                result.putAll((Object)(group.getKey() + "/" + slotType.getKey()), slotType.getValue().getModifiers().values());
            }
        }
        return result;
    }

    @Override
    public void clearModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearModifiers();
            }
        }
    }

    public void readData(class_11368 view) {
        Object object;
        Optional optional = view.method_71418(TrinketSaveData.MAP_CODEC);
        class_2371 dropped = class_2371.method_10211();
        if (optional.isPresent()) {
            TrinketSaveData data = (TrinketSaveData)optional.orElseThrow();
            object = data.data().keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Map<String, TrinketSaveData.InventoryData> groupTag = data.data().get(string);
                if (groupTag == null) continue;
                Map<String, TrinketInventory> groupSlots = this.inventory.get(string);
                if (groupSlots != null) {
                    for (String slotKey : groupTag.keySet()) {
                        TrinketSaveData.InventoryData slotTag = groupTag.get(slotKey);
                        TrinketInventory inv = groupSlots.get(slotKey);
                        if (inv != null) {
                            inv.fromMetadata(slotTag.metadata());
                        }
                        for (int i = 0; i < slotTag.items().size(); ++i) {
                            class_1799 stack = slotTag.items().get(i);
                            if (inv != null && i < inv.method_5439()) {
                                inv.method_5447(i, stack);
                                continue;
                            }
                            dropped.add((Object)stack);
                        }
                    }
                    continue;
                }
                for (String slotKey : groupTag.keySet()) {
                    dropped.addAll(groupTag.get(slotKey).items());
                }
            }
        }
        if ((object = this.entity.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)object;
            for (class_1799 class_17992 : dropped) {
                this.entity.method_5775(serverWorld, class_17992);
            }
        }
        HashMultimap slotMap = HashMultimap.create();
        this.forEach((arg_0, arg_1) -> this.lambda$readData$2((Multimap)slotMap, arg_0, arg_1));
        for (Map.Entry entry : this.getInventory().entrySet()) {
            for (Map.Entry slotEntry : ((Map)entry.getValue()).entrySet()) {
                String group = (String)entry.getKey();
                String slot = (String)slotEntry.getKey();
                String key = group + "/" + slot;
                Collection modifiers = slotMap.get((Object)key);
                TrinketInventory inventory = (TrinketInventory)slotEntry.getValue();
                for (class_1322 modifier : modifiers) {
                    inventory.removeCachedModifier(modifier);
                }
                inventory.clearCachedModifiers();
            }
        }
    }

    public void applySyncPacket(class_9129 buf) {
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            class_6903 ops = buf.method_56349().method_57093((DynamicOps)class_2509.field_11560);
            for (String groupKey : tag.method_10541()) {
                Map<String, TrinketInventory> groupSlots;
                class_2487 groupTag = tag.method_68568(groupKey);
                if (groupTag == null || (groupSlots = this.inventory.get(groupKey)) == null) continue;
                for (String slotKey : groupTag.method_10541()) {
                    class_2487 slotTag = groupTag.method_68568(slotKey);
                    class_2499 list = slotTag.method_68569("Items");
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.applySyncMetadata(slotTag.method_67492("Metadata", TrinketSaveData.Metadata.CODEC, (DynamicOps)ops).orElse(TrinketSaveData.Metadata.EMPTY));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 c = list.method_68582(i);
                        class_1799 stack = class_1799.field_49266.decode((DynamicOps)ops, (Object)c).result().map(Pair::getFirst).orElse(class_1799.field_8037);
                        if (inv == null || i >= inv.method_5439()) continue;
                        inv.method_5447(i, stack);
                    }
                }
            }
            class_1309 class_13092 = this.entity;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                ((TrinketPlayerScreenHandler)player.field_7498).trinkets$updateTrinketSlots(false);
            }
        }
    }

    public void writeData(class_11372 view) {
        TrinketSaveData data = new TrinketSaveData(new HashMap<String, Map<String, TrinketSaveData.InventoryData>>());
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            HashMap<String, TrinketSaveData.InventoryData> groupTag = new HashMap<String, TrinketSaveData.InventoryData>();
            for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
                TrinketInventory inv = slot.getValue();
                ArrayList<class_1799> items = new ArrayList<class_1799>();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    items.add(inv.method_5438(i).method_7972());
                }
                TrinketSaveData.Metadata metadata = this.syncing ? inv.getSyncMetadata() : inv.toMetadata();
                groupTag.put(slot.getKey(), new TrinketSaveData.InventoryData(metadata, items));
            }
            data.data().put(group.getKey(), groupTag);
        }
        view.method_71460(TrinketSaveData.MAP_CODEC, (Object)data);
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        this.syncing = true;
        class_11362 tag = class_11362.method_71458((class_8942)class_8942.field_60348);
        this.writeData((class_11372)tag);
        this.syncing = false;
        buf.method_10794((class_2520)tag.method_71475());
    }

    public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory, boolean sameCharacter) {
        return lossless || keepInventory;
    }

    @Override
    public boolean isEquipped(Predicate<class_1799> predicate) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    if (!predicate.test(inv.method_5438(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<class_3545<SlotReference, class_1799>> getEquipped(Predicate<class_1799> predicate) {
        ArrayList<class_3545<SlotReference, class_1799>> list = new ArrayList<class_3545<SlotReference, class_1799>>();
        this.forEach((slotReference, itemStack) -> {
            if (predicate.test((class_1799)itemStack)) {
                list.add(new class_3545(slotReference, itemStack));
            }
        });
        return list;
    }

    @Override
    public void forEach(BiConsumer<SlotReference, class_1799> consumer) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    consumer.accept(new SlotReference(inv, i), inv.method_5438(i));
                }
            }
        }
    }

    private /* synthetic */ void lambda$readData$2(Multimap slotMap, SlotReference ref, class_1799 stack) {
        if (!stack.method_7960()) {
            Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(stack, ref, this.entity);
            for (class_6880 entityAttribute : map.keySet()) {
                Object patt0$temp;
                if (!entityAttribute.method_40227() || !((patt0$temp = entityAttribute.comp_349()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                SlotAttributes.SlotEntityAttribute slotEntityAttribute = (SlotAttributes.SlotEntityAttribute)((Object)patt0$temp);
                slotMap.putAll((Object)slotEntityAttribute.slot, (Iterable)map.get((Object)entityAttribute));
            }
        }
    }
}

