/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketSaveData;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import dev.emi.trinkets.payload.SyncInventoryPayload;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_5131;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private final Map<String, class_1799> lastEquippedTrinkets = new HashMap<String, class_1799>();

    @Shadow
    public abstract class_5131 method_6127();

    private LivingEntityMixin() {
        super(null, null);
    }

    @Inject(at={@At(value="HEAD")}, method={"canFreeze"}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Optional<TrinketComponent> component = TrinketsApi.getTrinketComponent((class_1309)this);
        if (component.isPresent()) {
            for (class_3545<SlotReference, class_1799> equipped : component.get().getAllEquipped()) {
                if (!((class_1799)equipped.method_15441()).method_31573(class_3489.field_28041)) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"dropInventory"})
    private void dropInventory(class_3218 world, CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        boolean keepInv = world.method_64395().method_8355(class_1928.field_19389);
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket(stack.method_7909()).getDropRule((class_1799)stack, (SlotReference)ref, entity);
            dropRule = ((TrinketDropCallback)TrinketDropCallback.EVENT.invoker()).drop(dropRule, (class_1799)stack, (SlotReference)ref, entity);
            TrinketInventory inventory = ref.inventory();
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = inventory.getSlotType().getDropRule();
            }
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = keepInv && entity.method_5864() == class_1299.field_6097 ? TrinketEnums.DropRule.KEEP : (class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655) ? TrinketEnums.DropRule.DESTROY : TrinketEnums.DropRule.DROP);
            }
            switch (dropRule) {
                case DROP: {
                    this.dropFromEntity((class_1799)stack);
                }
                case DESTROY: {
                    inventory.method_5447(ref.index(), class_1799.field_8037);
                    break;
                }
            }
        }));
    }

    @Unique
    private void dropFromEntity(class_1799 stack) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 player = (class_1657)livingEntityMixin;
            livingEntityMixin = player.method_7329(stack, true, false);
        } else {
            livingEntityMixin = this.method_37908();
            if (livingEntityMixin instanceof class_3218) {
                class_3218 serverWorld = (class_3218)livingEntityMixin;
                livingEntityMixin = this.method_5775(serverWorld, stack);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        if (entity.method_31481()) {
            return;
        }
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> {
            HashMap newlyEquippedTrinkets = new HashMap();
            HashMap<String, class_1799> contentUpdates = new HashMap<String, class_1799>();
            trinkets.forEach((ref, stack) -> {
                TrinketInventory inventory = ref.inventory();
                SlotType slotType = inventory.getSlotType();
                int index = ref.index();
                class_1799 oldStack = this.getOldStack(slotType, index);
                class_1799 newStack = inventory.method_5438(index);
                class_1799 newStackCopy = newStack.method_7972();
                String newRef = slotType.getGroup() + "/" + slotType.getName() + "/" + index;
                if (!class_1799.method_7973((class_1799)newStack, (class_1799)oldStack)) {
                    TrinketsApi.getTrinket(oldStack.method_7909()).onUnequip(oldStack, (SlotReference)ref, entity);
                    ((TrinketUnequipCallback)TrinketUnequipCallback.EVENT.invoker()).onUnequip(oldStack, (SlotReference)ref, entity);
                    TrinketsApi.getTrinket(newStack.method_7909()).onEquip(newStack, (SlotReference)ref, entity);
                    ((TrinketEquipCallback)TrinketEquipCallback.EVENT.invoker()).onEquip(newStack, (SlotReference)ref, entity);
                    class_1937 world = this.method_37908();
                    if (!world.field_9236) {
                        SlotAttributes.SlotEntityAttribute slotAttr;
                        Object patt0$temp;
                        HashSet toRemove;
                        HashMultimap slotMap;
                        Multimap<class_6880<class_1320>, class_1322> map;
                        contentUpdates.put(newRef, newStackCopy);
                        if (!oldStack.method_7960()) {
                            map = TrinketModifiers.get(oldStack, ref, entity);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (class_6880 attr : map.keySet()) {
                                if (!attr.method_40227() || !((patt0$temp = attr.comp_349()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)((Object)((Object)((Object)((Object)patt0$temp))));
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(attr);
                            }
                            for (class_6880 attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            map.asMap().forEach((attribute, modifiers) -> {
                                class_1324 entityAttributeInstance = this.method_6127().method_45329(attribute);
                                if (entityAttributeInstance != null) {
                                    modifiers.forEach(modifier -> entityAttributeInstance.method_6200(modifier.comp_2447()));
                                }
                            });
                            trinkets.removeModifiers((Multimap<String, class_1322>)slotMap);
                        }
                        if (!newStack.method_7960()) {
                            map = TrinketModifiers.get(newStack, ref, entity);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (class_6880 attr : map.keySet()) {
                                if (!attr.method_40227() || !((patt0$temp = attr.comp_349()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)((Object)((Object)((Object)((Object)patt0$temp))));
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(attr);
                            }
                            for (class_6880 attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            map.forEach((attribute, attributeModifier) -> {
                                class_1324 entityAttributeInstance = this.method_6127().method_45329(attribute);
                                if (entityAttributeInstance != null) {
                                    entityAttributeInstance.method_6200(attributeModifier.comp_2447());
                                    entityAttributeInstance.method_26835(attributeModifier);
                                }
                            });
                            trinkets.addTemporaryModifiers((Multimap<String, class_1322>)slotMap);
                        }
                    }
                }
                TrinketsApi.getTrinket(newStack.method_7909()).tick(newStack, (SlotReference)ref, entity);
                class_1799 tickedStack = inventory.method_5438(index);
                if (tickedStack.method_7909() == newStackCopy.method_7909()) {
                    newlyEquippedTrinkets.put(newRef, tickedStack.method_7972());
                } else {
                    newlyEquippedTrinkets.put(newRef, newStackCopy);
                }
            });
            class_1937 world = this.method_37908();
            if (!world.field_9236) {
                Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();
                if (!contentUpdates.isEmpty() || !inventoriesToSend.isEmpty()) {
                    HashMap<String, TrinketSaveData.Metadata> map = new HashMap<String, TrinketSaveData.Metadata>();
                    for (TrinketInventory trinketInventory : inventoriesToSend) {
                        map.put(trinketInventory.getSlotType().getId(), trinketInventory.getSyncMetadata());
                    }
                    SyncInventoryPayload packet = new SyncInventoryPayload(this.method_5628(), contentUpdates, map);
                    for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
                    }
                    if (entity instanceof class_3222) {
                        class_3222 class_32222 = (class_3222)entity;
                        ServerPlayNetworking.send((class_3222)class_32222, (class_8710)packet);
                        if (!inventoriesToSend.isEmpty()) {
                            ((TrinketPlayerScreenHandler)class_32222.field_7498).trinkets$updateTrinketSlots(false);
                        }
                    }
                    inventoriesToSend.clear();
                }
            }
            this.lastEquippedTrinkets.clear();
            this.lastEquippedTrinkets.putAll(newlyEquippedTrinkets);
        });
    }

    @Unique
    private class_1799 getOldStack(SlotType type, int index) {
        return this.lastEquippedTrinkets.getOrDefault(type.getGroup() + "/" + type.getName() + "/" + index, class_1799.field_8037);
    }
}

