/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.core;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.CombinedPlayerCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.impl.MapIdManager;
import eu.pb4.mapcanvas.impl.MultiMapCanvasImpl;
import eu.pb4.mapcanvas.impl.SingleMapCanvas;
import net.minecraft.class_3620;

public interface DrawableCanvas {
    default public void set(int x, int y, class_3620 color, class_3620.class_6594 brightness) {
        this.setRaw(x, y, color.method_38481(brightness));
    }

    default public void set(int x, int y, CanvasColor color) {
        this.setRaw(x, y, color.renderColor);
    }

    default public CanvasColor get(int x, int y) {
        return CanvasColor.BY_RENDER_COLOR[Byte.toUnsignedInt(this.getRaw(x, y))];
    }

    default public void fill(class_3620 color, class_3620.class_6594 brightness) {
        this.fillRaw(color.method_38481(brightness));
    }

    default public void fill(CanvasColor color) {
        this.fillRaw(color.renderColor);
    }

    public byte getRaw(int var1, int var2);

    public void setRaw(int var1, int var2, byte var3);

    default public void fillRaw(byte color) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.setRaw(x, y, color);
            }
        }
    }

    public int getHeight();

    public int getWidth();

    default public CanvasImage copy() {
        int width = this.getWidth();
        int height = this.getHeight();
        CanvasImage image = new CanvasImage(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRaw(x, y, this.getRaw(x, y));
            }
        }
        return image;
    }

    default public CanvasImage copy(int x, int y, int width, int height) {
        int newWidth = Math.min(this.getWidth() - x, width);
        int newHeight = Math.min(this.getHeight() - y, height);
        CanvasImage image = new CanvasImage(newWidth, newHeight);
        for (int lx = 0; lx < newWidth; ++lx) {
            for (int ly = 0; ly < newHeight; ++ly) {
                image.setRaw(lx, ly, this.getRaw(x + lx, y + ly));
            }
        }
        return image;
    }

    public static PlayerCanvas create() {
        return new SingleMapCanvas(MapIdManager.requestMapId());
    }

    public static CombinedPlayerCanvas create(int sectionWidth, int sectionHeight) {
        return new MultiMapCanvasImpl(sectionWidth, sectionHeight);
    }

    public static CanvasImage createImage(int width, int height) {
        return new CanvasImage(width, height);
    }
}

