/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import java.util.List;
import java.util.Optional;

public interface CanvasFont {
    default public int getTextWidth(String text, double size) {
        if (text.isEmpty()) {
            return 0;
        }
        int posX = 0;
        int[] array = text.codePoints().toArray();
        int length = array.length - 1;
        for (int i = 0; i < length; ++i) {
            posX += this.getGlyphWidth(array[i], size, 2);
        }
        return posX + this.getGlyphWidth(array[length], size, 0);
    }

    default public void drawText(DrawableCanvas canvas, String text, int x, int y, double size, CanvasColor color) {
        int posX = 0;
        int posY = 0;
        for (int character : text.codePoints().toArray()) {
            if (character == 10) {
                posY = (int)((double)posY + (size + 2.0));
                posX = 0;
                continue;
            }
            posX += this.drawGlyph(canvas, character, x + posX, y + posY, size, 2, color);
        }
    }

    public int getGlyphWidth(int var1, double var2, int var4);

    public int drawGlyph(DrawableCanvas var1, int var2, int var3, int var4, double var5, int var7, CanvasColor var8);

    public boolean containsGlyph(int var1);

    default public Metadata getMetadata() {
        return Metadata.empty();
    }

    public record Metadata(String name, List<String> authors, Optional<String> description) {
        private static Metadata EMPTY = new Metadata("unnamed", List.of(), Optional.empty());

        public String defaultedDescription() {
            return this.description.orElse("A Map Canvas Font");
        }

        public static Metadata create(String name, List<String> authors, String description) {
            return new Metadata(name, List.copyOf(authors), Optional.ofNullable(description));
        }

        public static Metadata create(String name, List<String> authors) {
            return new Metadata(name, List.copyOf(authors), Optional.empty());
        }

        public static Metadata create(String name) {
            return new Metadata(name, List.of(), Optional.empty());
        }

        public static Metadata empty() {
            return EMPTY;
        }
    }
}

