/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.utils;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasIcon;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.IconContainer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Collection;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public final class CanvasUtils {
    public static final int MAP_DATA_SIZE = 128;
    public static final int MAP_ICON_SIZE = 256;
    private static final byte[] RGB_TO_MAP_LEGACY = new byte[0x1000000];
    @Nullable
    private static IndexColorModel colorModel;

    private CanvasUtils() {
    }

    public static void clear(DrawableCanvas canvas) {
        CanvasUtils.clear(canvas, CanvasColor.CLEAR);
    }

    public static void clear(DrawableCanvas canvas, CanvasColor color) {
        canvas.fill(color);
    }

    public static void fill(DrawableCanvas canvas, int x1, int y1, int x2, int y2, CanvasColor color) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        byte renderColor = color.getRenderColor();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                canvas.setRaw(x, y, renderColor);
            }
        }
    }

    public static void draw(DrawableCanvas canvas, int x, int y, DrawableCanvas source) {
        int width = source.getWidth();
        int height = source.getHeight();
        for (int lx = 0; lx < width; ++lx) {
            for (int ly = 0; ly < height; ++ly) {
                byte color = source.getRaw(lx, ly);
                if (color == 0) continue;
                canvas.setRaw(lx + x, ly + y, color);
            }
        }
        if (canvas instanceof IconContainer) {
            IconContainer container = (IconContainer)((Object)canvas);
            if (source instanceof IconContainer) {
                IconContainer sourceContainer = (IconContainer)((Object)source);
                for (CanvasIcon icon : sourceContainer.getIcons()) {
                    container.createIcon(icon.getType(), icon.isVisible(), icon.getX(), icon.getY(), icon.getRotation(), icon.getText());
                }
            }
        }
    }

    public static void draw(DrawableCanvas canvas, int x, int y, int width, int height, DrawableCanvas source) {
        int baseWidth = source.getWidth();
        int baseHeight = source.getHeight();
        double deltaX = (double)baseWidth / (double)width;
        double deltaY = (double)baseHeight / (double)height;
        for (int lx = 0; lx < width; ++lx) {
            for (int ly = 0; ly < height; ++ly) {
                byte color = source.getRaw((int)((double)lx * deltaX), (int)((double)ly * deltaY));
                if (color == 0) continue;
                canvas.setRaw(lx + x, ly + y, color);
            }
        }
        if (canvas instanceof IconContainer) {
            IconContainer container = (IconContainer)((Object)canvas);
            if (source instanceof IconContainer) {
                IconContainer sourceContainer = (IconContainer)((Object)source);
                for (CanvasIcon icon : sourceContainer.getIcons()) {
                    container.createIcon(icon.getType(), icon.isVisible(), (int)((double)icon.getX() * deltaX), (int)((double)icon.getY() * deltaY), icon.getRotation(), icon.getText());
                }
            }
        }
    }

    public static CanvasColor findClosestColorARGB(int argb) {
        if (argb >> 24 == 0) {
            return CanvasColor.CLEAR;
        }
        return CanvasUtils.findClosestColor(argb);
    }

    public static CanvasColor findClosestColor(int rgb) {
        return CanvasColor.values()[Byte.toUnsignedInt(CanvasUtils.findClosestRawColor(rgb))];
    }

    public static byte findClosestRawColorARGB(int argb) {
        if (argb >> 24 == 0) {
            return 0;
        }
        return CanvasUtils.findClosestRawColor(argb);
    }

    public static byte findClosestRawColor(int rgb) {
        if (RGB_TO_MAP_LEGACY[rgb &= 0xFFFFFF] == 0) {
            CanvasUtils.RGB_TO_MAP_LEGACY[rgb] = CanvasUtils.findClosestColorMath(rgb).getRenderColor();
        }
        return RGB_TO_MAP_LEGACY[rgb];
    }

    public static class_2487 toNbt(DrawableCanvas canvas, class_7225.class_7874 lookup) {
        IconContainer iconContainer;
        Collection<CanvasIcon> iconsSource;
        class_2487 nbt = new class_2487();
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        nbt.method_10582("DataType", "MapCanvasImage");
        nbt.method_10569("Version", 0);
        nbt.method_10569("Width", width);
        nbt.method_10569("Height", height);
        byte[] data = new byte[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                data[x + y * width] = canvas.getRaw(x, y);
            }
        }
        nbt.method_10570("Data", data);
        if (canvas instanceof IconContainer && !(iconsSource = (iconContainer = (IconContainer)((Object)canvas)).getIcons()).isEmpty()) {
            class_2499 icons = new class_2499();
            for (CanvasIcon icon : iconsSource) {
                class_2487 iconNbt = new class_2487();
                iconNbt.method_10582("TypeId", ((class_5321)icon.getType().method_40230().orElseThrow()).method_29177().toString());
                iconNbt.method_10556("Vis", icon.isVisible());
                iconNbt.method_10569("X", icon.getX());
                iconNbt.method_10569("Y", icon.getY());
                iconNbt.method_10567("Rot", icon.getRotation());
                if (icon.getText() != null) {
                    iconNbt.method_10582("Text", ((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)icon.getText()).getOrThrow()).toString());
                }
                icons.add((Object)iconNbt);
            }
            nbt.method_10566("Icons", (class_2520)icons);
        }
        return nbt;
    }

    public static BufferedImage toImage(DrawableCanvas canvas) {
        BufferedImage image = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                CanvasColor color = canvas.get(x, y);
                if (color.getColor() == class_3620.field_16008) continue;
                image.setRGB(x, y, color.getRgbColor() | 0xFF000000);
            }
        }
        return image;
    }

    public static BufferedImage wrapAsImage(final DrawableCanvas canvas) {
        DataBuffer dataBuffer;
        final int width = canvas.getWidth();
        int size = canvas.getHeight() * canvas.getWidth();
        if (canvas instanceof CanvasImage) {
            final CanvasImage canvasImage = (CanvasImage)canvas;
            dataBuffer = new DataBuffer(0, size){

                @Override
                public int getElem(int bank, int i) {
                    return Byte.toUnsignedInt(canvasImage.getRawAt(i));
                }

                @Override
                public void setElem(int bank, int i, int val) {
                    canvasImage.setRawAt(i, (byte)val);
                }
            };
        } else {
            dataBuffer = new DataBuffer(0, size){

                @Override
                public int getElem(int bank, int i) {
                    return Byte.toUnsignedInt(canvas.getRaw(i % width, i / width));
                }

                @Override
                public void setElem(int bank, int i, int val) {
                    canvas.setRaw(i % width, i / width, (byte)val);
                }
            };
        }
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, width, canvas.getHeight(), width, 1, new int[]{0}, new Point(0, 0));
        return new BufferedImage(CanvasUtils.getMapColorModel(), raster, false, null);
    }

    public static Graphics2D getGraphics(DrawableCanvas canvas) {
        return CanvasUtils.wrapAsImage(canvas).createGraphics();
    }

    public static IndexColorModel getMapColorModel() {
        if (colorModel != null) {
            // empty if block
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        byte[] a = new byte[256];
        for (int i = 4; i < 256; ++i) {
            CanvasColor color = CanvasColor.getFromRaw(i);
            int rgb = color.getRgbColor();
            r[i] = (byte)class_9848.method_61327((int)rgb);
            g[i] = (byte)class_9848.method_61329((int)rgb);
            b[i] = (byte)class_9848.method_61331((int)rgb);
            a[i] = -1;
        }
        colorModel = new IndexColorModel(8, 247, r, g, b, a);
        return colorModel;
    }

    private static CanvasColor findClosestColorMath(int rgb) {
        int shortestDistance = Integer.MAX_VALUE;
        CanvasColor out = CanvasColor.CLEAR;
        int redColor = rgb >> 16 & 0xFF;
        int greenColor = rgb >> 8 & 0xFF;
        int blueColor = rgb & 0xFF;
        for (CanvasColor canvasColor : CanvasColor.values()) {
            if (canvasColor.getColor() == class_3620.field_16008) continue;
            int tmpColor = canvasColor.getRgbColor();
            int redCanvas = tmpColor >> 16 & 0xFF;
            int greenCanvas = tmpColor >> 8 & 0xFF;
            int blueCanvas = tmpColor & 0xFF;
            int distance = class_3532.method_34954((int)(redCanvas - redColor)) + class_3532.method_34954((int)(greenCanvas - greenColor)) + class_3532.method_34954((int)(blueCanvas - blueColor));
            if (distance >= shortestDistance) continue;
            out = canvasColor;
            shortestDistance = distance;
        }
        return out;
    }

    public static interface ColorMapper {
        public static final ColorMapper DEFAULT = CanvasUtils::findClosestRawColorARGB;
        public static final ColorMapper DEFAULT_BLACK_CLEAR = color -> (color & 0xFFFFFF) == 0 ? (byte)0 : CanvasUtils.findClosestRawColorARGB(color);

        public byte getRawColor(int var1);
    }
}

