/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl;

import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.impl.BaseMapCanvas;
import eu.pb4.mapcanvas.impl.MapIdManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2596;
import net.minecraft.class_2683;
import net.minecraft.class_3244;
import net.minecraft.class_9209;

public abstract class AbstractPlayerMapCanvas
extends BaseMapCanvas
implements PlayerCanvas {
    private final int mapId;
    private final class_9209 mapIdComponent;
    private boolean isDirty = false;
    private int changedMinX = 128;
    private int changedMinY = 128;
    private int changedMaxX = 0;
    private int changedMaxY = 0;
    private boolean isIconsDirty = false;
    private boolean markDestroyed = false;

    public AbstractPlayerMapCanvas(int id) {
        this.mapId = id;
        this.mapIdComponent = new class_9209(id);
    }

    @Override
    public boolean addPlayer(class_3244 player) {
        if (this.markDestroyed) {
            return false;
        }
        if (this.getPlayers().add(player)) {
            this.sendFull(player);
            return true;
        }
        return false;
    }

    protected void sendFull(class_3244 player) {
        ArrayList<class_20> icons = new ArrayList<class_20>();
        for (BaseMapCanvas.SimpleCanvasIcon icon : this.icons) {
            if (!icon.isVisible()) continue;
            icons.add(new class_20(icon.getType(), (byte)(icon.getX() - 128), (byte)(icon.getY() - 128), icon.getRotation(), Optional.ofNullable(icon.getText())));
        }
        player.method_14364((class_2596)new class_2683(this.mapIdComponent, 0, true, icons, new class_22.class_5637(0, 0, 128, 128, this.data)));
    }

    @Override
    public int getId() {
        return this.mapId;
    }

    @Override
    public class_9209 getIdComponent() {
        return this.mapIdComponent;
    }

    @Override
    public boolean removePlayer(class_3244 player) {
        return this.getPlayers().remove(player);
    }

    protected abstract Collection<class_3244> getPlayers();

    @Override
    public boolean isDirty() {
        return this.isDirty || this.isIconsDirty;
    }

    @Override
    protected void markPixelDirty(int x, int y) {
        this.isDirty = true;
        this.changedMinX = Math.min(this.changedMinX, x);
        this.changedMinY = Math.min(this.changedMinY, y);
        this.changedMaxX = Math.max(this.changedMaxX, x);
        this.changedMaxY = Math.max(this.changedMaxY, y);
    }

    @Override
    protected void markIconsDirty() {
        this.isIconsDirty = true;
    }

    @Override
    public void destroy() {
        if (this.markDestroyed) {
            return;
        }
        MapIdManager.freeMapId(this.mapId);
        this.markDestroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.markDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUpdates() {
        ArrayList<class_20> icons;
        class_22.class_5637 pixelData;
        if (this.markDestroyed) {
            return;
        }
        if (this.isDirty) {
            this.isDirty = false;
            int width = this.changedMaxX - this.changedMinX + 1;
            int height = this.changedMaxY - this.changedMinY + 1;
            byte[] bytes = new byte[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    bytes[x + y * width] = this.getRaw(this.changedMinX + x, this.changedMinY + y);
                }
            }
            pixelData = new class_22.class_5637(this.changedMinX, this.changedMinY, width, height, bytes);
            this.changedMinX = 128;
            this.changedMinY = 128;
            this.changedMaxX = 0;
            this.changedMaxY = 0;
        } else {
            pixelData = null;
        }
        if (this.isIconsDirty) {
            this.isIconsDirty = false;
            icons = new ArrayList<class_20>();
            for (BaseMapCanvas.SimpleCanvasIcon icon : this.icons) {
                if (!icon.isVisible()) continue;
                icons.add(new class_20(icon.getType(), (byte)(icon.getX() - 128), (byte)(icon.getY() - 128), icon.getRotation(), Optional.ofNullable(icon.getText())));
            }
        } else {
            icons = null;
        }
        if (pixelData != null || icons != null) {
            Collection<class_3244> players;
            class_2683 packet = new class_2683(this.mapIdComponent, 0, true, icons, pixelData);
            Collection<class_3244> collection = players = this.getPlayers();
            synchronized (collection) {
                for (class_3244 player : players) {
                    if (!player.method_48106()) continue;
                    player.method_14364((class_2596)packet);
                }
            }
        }
    }
}

