/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public record AwtFont(Font font, CanvasFont.Metadata metadata, boolean antiAliasing) implements CanvasFont
{
    private static final FontRenderContext CONTEXT = new FontRenderContext(null, false, false);
    private static final FontRenderContext CONTEXT_AA = new FontRenderContext(null, true, false);
    private static final float FONT_SCALE = 1.25f;

    @Override
    public int getTextWidth(String text, double size) {
        return (int)this.font.deriveFont((float)(size *= 1.25)).getStringBounds(text, this.getContext()).getWidth();
    }

    @Override
    public int getGlyphWidth(int character, double size, int offset) {
        return (int)this.font.deriveFont((float)(size *= 1.25)).getStringBounds(Character.toString(character), this.getContext()).getWidth();
    }

    @Override
    public int drawGlyph(DrawableCanvas canvas, int character, int x, int y, double size, int offset, CanvasColor color) {
        Font font = this.font.deriveFont((float)(size *= 1.25));
        GlyphVector shape = font.createGlyphVector(this.getContext(), Character.toChars(character));
        this.drawShape(canvas, shape, x, y, size, color);
        return (int)shape.getLogicalBounds().getWidth();
    }

    @Override
    public void drawText(DrawableCanvas canvas, String text, int x, int y, double size, CanvasColor color) {
        Font font = this.font.deriveFont((float)(size *= 1.25));
        for (String line : text.split("\n")) {
            GlyphVector shape = font.createGlyphVector(this.getContext(), line);
            this.drawShape(canvas, shape, x, y, size, color);
            y += (int)(size + 2.0);
        }
    }

    private void drawShape(DrawableCanvas canvas, GlyphVector shape, int x, int y, double size, CanvasColor color) {
        Shape outline = shape.getOutline();
        Rectangle2D bounds = shape.getLogicalBounds();
        int rgbColor = color.getRgbColor();
        byte raw = color.getRenderColor();
        if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            return;
        }
        BufferedImage image = new BufferedImage(class_3532.method_15384((double)bounds.getWidth()), class_3532.method_15384((double)(bounds.getHeight() + 2.0)), 10);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.translate(0.0, size);
        g.fill(outline);
        g.dispose();
        double offset = size * (double)0.3f;
        DataBuffer buf = image.getData().getDataBuffer();
        int height = image.getHeight();
        int width = image.getWidth();
        for (int ys = 0; ys < height; ++ys) {
            int yShift = ys * width;
            int ry = (int)((double)(ys + y) - offset);
            for (int xs = 0; xs < width; ++xs) {
                int val = buf.getElem(xs + yShift);
                if (val < 25) continue;
                int rx = xs + x;
                if (val == 255) {
                    canvas.setRaw(rx, ry, raw);
                    continue;
                }
                canvas.setRaw(rx, ry, CanvasUtils.findClosestRawColor(class_9848.method_61319((float)((float)val / 255.0f), (int)canvas.get(rx, ry).getRgbColor(), (int)rgbColor)));
            }
        }
    }

    @Override
    public boolean containsGlyph(int character) {
        return this.font.canDisplay(character);
    }

    @Override
    public CanvasFont.Metadata getMetadata() {
        return this.metadata;
    }

    private FontRenderContext getContext() {
        return this.antiAliasing ? CONTEXT_AA : CONTEXT;
    }
}

