/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.font.FontUtils;
import eu.pb4.mapcanvas.impl.font.LazyFont;
import eu.pb4.mapcanvas.impl.font.StackedFont;
import eu.pb4.mapcanvas.impl.font.StackedLazyFont;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_3532;

public final class BitmapFont
implements CanvasFont {
    public static final BitmapFont EMPTY = new BitmapFont(Glyph.INVALID, CanvasFont.Metadata.empty());
    public final Int2ObjectMap<Glyph> characters = new Int2ObjectOpenHashMap();
    public final Glyph defaultGlyph;
    private final CanvasFont.Metadata metadata;

    public BitmapFont(Glyph defaultGlyph, CanvasFont.Metadata metadata) {
        this.defaultGlyph = defaultGlyph;
        this.metadata = metadata;
    }

    public BitmapFont(Glyph defaultGlyph, Int2ObjectMap<Glyph> characters, CanvasFont.Metadata metadata) {
        this.defaultGlyph = defaultGlyph;
        for (Int2ObjectMap.Entry entry : characters.int2ObjectEntrySet()) {
            this.characters.put(entry.getIntKey(), (Object)((Glyph)entry.getValue()));
        }
        this.metadata = metadata;
    }

    public BitmapFont(Glyph defaultGlyph, Int2ObjectMap<Glyph> characters) {
        this(defaultGlyph, characters, CanvasFont.Metadata.empty());
    }

    @Override
    public int getGlyphWidth(int character, double size, int offset) {
        return ((Glyph)this.characters.getOrDefault(character, (Object)this.defaultGlyph)).getWidth(size, offset);
    }

    @Override
    public int drawGlyph(DrawableCanvas canvas, int character, int x, int y, double size, int offset, CanvasColor color) {
        return ((Glyph)this.characters.getOrDefault(character, (Object)this.defaultGlyph)).draw(canvas, x, y, size, offset, color);
    }

    @Override
    public boolean containsGlyph(int character) {
        return this.characters.containsKey(character);
    }

    @Override
    public CanvasFont.Metadata getMetadata() {
        return this.metadata;
    }

    public static BitmapFont tryConvert(CanvasFont font) {
        BitmapFont bitmapFont;
        CanvasFont canvasFont = font;
        Objects.requireNonNull(canvasFont);
        CanvasFont canvasFont2 = canvasFont;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BitmapFont.class, LazyFont.class, StackedFont.class, StackedLazyFont.class}, (Object)canvasFont2, n)) {
                case 0: {
                    BitmapFont bitmapFont2;
                    bitmapFont = bitmapFont2 = (BitmapFont)canvasFont2;
                    break block6;
                }
                case 1: {
                    LazyFont lazyFont = (LazyFont)canvasFont2;
                    bitmapFont = BitmapFont.tryConvert(lazyFont.font());
                    break block6;
                }
                case 2: {
                    StackedFont stackedFont = (StackedFont)canvasFont2;
                    if (!FontUtils.isBitmapFont(stackedFont)) {
                        n = 3;
                        continue block6;
                    }
                    BitmapFont[] fonts = (BitmapFont[])Arrays.stream(stackedFont.fonts()).map(BitmapFont::tryConvert).toArray(BitmapFont[]::new);
                    BitmapFont out = new BitmapFont(fonts[0].defaultGlyph, stackedFont.getMetadata());
                    for (int i = fonts.length - 1; i >= 0; --i) {
                        out.characters.putAll(fonts[i].characters);
                    }
                    bitmapFont = out;
                    break block6;
                }
                case 3: {
                    StackedLazyFont stackedFont = (StackedLazyFont)canvasFont2;
                    if (!FontUtils.isBitmapFont(stackedFont)) {
                        n = 4;
                        continue block6;
                    }
                    BitmapFont[] fonts = (BitmapFont[])Arrays.stream(stackedFont.fonts()).map(BitmapFont::tryConvert).toArray(BitmapFont[]::new);
                    BitmapFont out = new BitmapFont(fonts[0].defaultGlyph, stackedFont.getMetadata());
                    for (int i = fonts.length - 1; i >= 0; --i) {
                        out.characters.putAll(fonts[i].characters);
                    }
                    bitmapFont = out;
                    break block6;
                }
                default: {
                    bitmapFont = null;
                    break block6;
                }
            }
            break;
        }
        return bitmapFont;
    }

    public record Glyph(int width, int height, int ascend, int fontWidth, int logicalHeight, boolean[] texture) {
        public static final Glyph INVALID;
        public static final Glyph EMPTY;
        public static final Glyph ATLAS;
        public static final Glyph PLAYER;

        private static boolean[] convert(int size, String string) {
            boolean[] texture = new boolean[size];
            string = string.replace("\n", "");
            for (int i = 0; i < string.length(); ++i) {
                texture[i] = string.charAt(i) == 'x';
            }
            return texture;
        }

        public int draw(DrawableCanvas canvas, int x, int y, double size, int offset, CanvasColor color) {
            if (this.logicalHeight() == 0 || this.height() == 0) {
                return (int)((double)this.fontWidth() * (size / 8.0));
            }
            double textureScale = (double)this.height() / (double)this.logicalHeight();
            double baseScale = size / textureScale / 8.0;
            for (int fX = 0; fX < this.width(); ++fX) {
                for (int fY = 0; fY < this.height(); ++fY) {
                    if (!this.texture()[fX + fY * this.width()]) continue;
                    int lX = 0;
                    while ((double)lX < baseScale) {
                        int lY = 0;
                        while ((double)lY < baseScale) {
                            canvas.set(x + class_3532.method_15357((double)((double)fX * baseScale)) + lX, y + class_3532.method_15357((double)(((double)fY + (double)(7 - this.ascend()) * textureScale) * baseScale)) + lY, color);
                            ++lY;
                        }
                        ++lX;
                    }
                }
            }
            return (int)((double)(this.fontWidth() + offset) * baseScale);
        }

        public int getWidth(double size, int offset) {
            if (this.logicalHeight() == 0 || this.height() == 0) {
                return (int)((double)this.fontWidth() * (size / 8.0));
            }
            double textureScale = (double)this.height() / (double)this.logicalHeight();
            double baseScale = size / textureScale / 8.0;
            return (int)((double)(this.fontWidth() + offset) * baseScale);
        }

        static {
            EMPTY = new Glyph(0, 0, 0, 0, 0, new boolean[0]);
            ATLAS = new Glyph(8, 8, 8, 8, 8, Glyph.convert(64, "xxxxxxxx\nxx----xx\nx-x--x-x\nx--xx--x\nx--xx--x\nx-x--x-x\nxx----xx\nxxxxxxxx\n"));
            PLAYER = new Glyph(8, 8, 8, 8, 8, Glyph.convert(64, "xxxxxxxx\nxxxxxxxx\nx------x\n--------\n-xx--xx-\n---xx---\n--x--x--\n--xxxx--\n"));
            boolean[] array = new boolean[40];
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 8; ++y) {
                    if (x != 0 && y != 0 && x != 4 && y != 7) continue;
                    array[x + y * 5] = true;
                }
            }
            INVALID = new Glyph(5, 8, 7, 5, 8, array);
        }
    }
}

