/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.font.LazyCanvasFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;

public record StackedLazyFont(LazyCanvasFont[] fonts, CanvasFont.Metadata metadata) implements LazyCanvasFont
{
    @Override
    public int getGlyphWidth(int character, double size, int offset) {
        for (LazyCanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return font.getGlyphWidth(character, size, offset);
        }
        return BitmapFont.EMPTY.getGlyphWidth(character, size, offset);
    }

    @Override
    public int drawGlyph(DrawableCanvas canvas, int character, int x, int y, double size, int offset, CanvasColor color) {
        for (LazyCanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return font.drawGlyph(canvas, character, x, y, size, offset, color);
        }
        return BitmapFont.EMPTY.getGlyphWidth(character, size, offset);
    }

    @Override
    public boolean containsGlyph(int character) {
        for (LazyCanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CanvasFont.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isLoaded() {
        for (LazyCanvasFont x : this.fonts) {
            if (x.isLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void requestLoad() {
        for (LazyCanvasFont x : this.fonts) {
            x.requestLoad();
        }
    }
}

