/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.core;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.mapcanvas.api.core.CanvasIcon;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.IconContainer;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.mapcanvas.impl.image.FloydSteinbergDither;
import eu.pb4.mapcanvas.impl.image.RawImage;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1208;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3551;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public final class CanvasImage
implements DrawableCanvas,
IconContainer {
    private final int width;
    private final int height;
    private final byte[] data;
    private final Set<ImageCanvasIcon> icons = new HashSet<ImageCanvasIcon>();
    private int iconId = 0;

    public CanvasImage(int width, int height) {
        this(width, height, new byte[width * height]);
    }

    protected CanvasImage(int width, int height, byte[] data) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public static CanvasImage from(BufferedImage image) {
        return CanvasImage.from(image, CanvasUtils.ColorMapper.DEFAULT);
    }

    public static CanvasImage from(BufferedImage image, CanvasUtils.ColorMapper mapper) {
        int width = image.getWidth();
        int height = image.getHeight();
        CanvasImage canvas = new CanvasImage(width, height);
        int pixels = width * height;
        int type = image.getType();
        if (type >= 5 && type <= 7 || type == 12 || type == 0) {
            RawImage rawImage = RawImage.convert(image);
            for (int i = 0; i < pixels; ++i) {
                canvas.data[i] = mapper.getRawColor(rawImage.data()[i]);
            }
        } else {
            DataBuffer buf = image.getData().getDataBuffer();
            ColorModel color = image.getColorModel();
            for (int i = 0; i < pixels; ++i) {
                canvas.data[i] = mapper.getRawColor(color.getRGB(buf.getElem(i)));
            }
        }
        return canvas;
    }

    public static CanvasImage fromWithFloydSteinbergDither(BufferedImage image) {
        return CanvasImage.fromWithFloydSteinbergDither(image, CanvasUtils.ColorMapper.DEFAULT);
    }

    public static CanvasImage fromWithFloydSteinbergDither(BufferedImage image, CanvasUtils.ColorMapper mapper) {
        RawImage rawImage = RawImage.convert(image);
        int width = rawImage.width();
        int height = rawImage.height();
        CanvasImage canvas = new CanvasImage(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                canvas.set(x, y, FloydSteinbergDither.sample(rawImage, x, y, mapper));
            }
        }
        return canvas;
    }

    public static CanvasImage from(BufferedImage image, ColorResolver resolver) {
        int width = image.getWidth();
        int height = image.getHeight();
        CanvasImage canvas = new CanvasImage(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                canvas.setRaw(x, y, resolver.getRawColor(image, x, y));
            }
        }
        return canvas;
    }

    public static CanvasImage from(class_22 state) {
        CanvasImage canvas = new CanvasImage(128, 128);
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                canvas.setRaw(x, y, state.field_122[x + y * 128]);
            }
        }
        for (class_20 icon : state.method_32373()) {
            canvas.createIcon((class_6880<class_9428>)icon.comp_1842(), icon.comp_1843() - 128, icon.comp_1844() - 128, icon.comp_1845(), icon.comp_1846().orElse(null));
        }
        return canvas;
    }

    @Nullable
    public static CanvasImage from(class_2487 nbt, class_7225.class_7874 lookup) {
        block7: {
            try {
                if (nbt.method_68564("DataType", "").equals("MapCanvasImage") && nbt.method_68083("Version", 0) != 0) {
                    int width = nbt.method_68083("Width", 0);
                    int height = nbt.method_68083("Height", 0);
                    byte[] data = nbt.method_10547("Data").orElse(new byte[0]);
                    CanvasImage image = new CanvasImage(width, height, Arrays.copyOf(data, data.length));
                    for (class_2520 tmpIcon : nbt.method_68569("Icons")) {
                        if (!(tmpIcon instanceof class_2487)) continue;
                        class_2487 icon = (class_2487)tmpIcon;
                        image.createIcon((class_6880<class_9428>)lookup.method_46762(class_7924.field_50082).method_46746(class_5321.method_29179((class_5321)class_7924.field_50082, (class_2960)class_2960.method_60654((String)icon.method_68564("TypeId", "")))).map(x -> x).orElse(class_21.field_91), icon.method_68566("Vis", false), icon.method_68083("X", 0), icon.method_68083("Y", 0), icon.method_68562("Rot", (byte)0), icon.method_10545("Text") ? (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)lookup.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)JsonParser.parseString((String)icon.method_68564("Text", ""))).result().orElseThrow()).getFirst() : null);
                    }
                    return image;
                }
                if (!nbt.method_10545("DataVersion") || !nbt.method_10545("data")) break block7;
                int version = nbt.method_68083("DataVersion", 1343);
                if (4671 > version) {
                    try {
                        nbt = (class_2487)class_3551.method_15450().update(class_1208.field_45092, new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt), version, 4671).getValue();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return CanvasImage.from((class_22)((Pair)class_22.field_56478.decode((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).getOrThrow()).getFirst());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public byte getRaw(int x, int y) {
        if (x >= this.width || y >= this.height || x < 0 || y < 0) {
            return 0;
        }
        return this.data[x + y * this.width];
    }

    @Override
    public void setRaw(int x, int y, byte color) {
        if (x >= this.width || y >= this.height || x < 0 || y < 0) {
            return;
        }
        this.data[x + y * this.width] = color;
    }

    @Override
    public void fillRaw(byte color) {
        Arrays.fill(this.data, color);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public Collection<CanvasIcon> getIcons() {
        return Collections.unmodifiableCollection(this.icons);
    }

    @Override
    public CanvasIcon createIcon() {
        ImageCanvasIcon icon = new ImageCanvasIcon(this.iconId++);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public CanvasIcon createIcon(class_6880<class_9428> type, boolean visible, int x, int y, byte rotation, @Nullable class_2561 text) {
        ImageCanvasIcon icon = new ImageCanvasIcon(this.iconId++, visible, type, x, y, rotation, text);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public void removeIcon(CanvasIcon icon) {
        this.icons.remove(icon);
    }

    public byte getRawAt(int index) {
        return this.data[index];
    }

    public void setRawAt(int index, byte data) {
        this.data[index] = data;
    }

    @FunctionalInterface
    public static interface ColorResolver {
        public static final ColorResolver DEFAULT = (image, x, y) -> CanvasUtils.findClosestRawColorARGB(image.getRGB(x, y));
        public static final ColorResolver DEFAULT_BLACK_CLEAR = (image, x, y) -> {
            int color = image.getRGB(x, y);
            return (color & 0xFFFFFF) == 0 ? (byte)0 : CanvasUtils.findClosestRawColorARGB(color);
        };

        public byte getRawColor(BufferedImage var1, int var2, int var3);
    }

    private final class ImageCanvasIcon
    implements CanvasIcon {
        public final int id;
        private class_2561 text;
        private class_6880<class_9428> type = class_21.field_91;
        private int x = 0;
        private int y = 0;
        private byte rotation = 0;
        private boolean isVisible = false;

        protected ImageCanvasIcon(int id) {
            this.id = id;
        }

        protected ImageCanvasIcon(int id, boolean visible, class_6880<class_9428> type, int x, int y, @Nullable byte rotation, class_2561 text) {
            this.id = id;
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.text = text;
            this.isVisible = visible;
        }

        @Override
        public class_6880<class_9428> getType() {
            return this.type;
        }

        @Override
        public void setType(class_6880<class_9428> type) {
            if (this.type != type) {
                this.type = type;
            }
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public byte getRotation() {
            return this.rotation;
        }

        @Override
        public void move(int x, int y, byte rotation) {
            if (this.x != x || this.y != y || this.rotation != rotation) {
                this.x = x;
                this.y = y;
                this.rotation = rotation;
            }
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        @Override
        public void setVisibility(boolean visibility) {
            if (this.isVisible != visibility) {
                this.isVisible = visibility;
            }
        }

        @Override
        public class_2561 getText() {
            return this.text;
        }

        @Override
        public void setText(@Nullable class_2561 text) {
            if (!Objects.equals(this.text, text)) {
                this.text = text;
            }
        }

        public DrawableCanvas getOwningCanvas() {
            return CanvasImage.this;
        }
    }
}

