/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.font.FontRegistry;
import eu.pb4.mapcanvas.api.font.FontUtils;
import eu.pb4.mapcanvas.api.font.LazyCanvasFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import eu.pb4.mapcanvas.impl.font.MojangUnifontFont;
import eu.pb4.mapcanvas.impl.font.StackedLazyFont;
import eu.pb4.mapcanvas.impl.font.serialization.RawBitmapFontSerializer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public final class DefaultFonts {
    public static final FontRegistry REGISTRY = new FontRegistry(class_2960.method_60655((String)"mapcanvasapi", (String)"empty"));
    public static final CanvasFont VANILLA;
    public static final CanvasFont ALT;
    public static final CanvasFont ILLAGER_ALT;
    public static final CanvasFont UNSANDED;
    public static final CanvasFont UNSANDED_BASE;
    public static final LazyCanvasFont UNIFONT;
    public static final LazyCanvasFont UNIFONT_JP;

    private DefaultFonts() {
    }

    private static BitmapFont read(Path path) {
        BitmapFont font;
        try {
            font = RawBitmapFontSerializer.read(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (Exception e) {
            font = BitmapFont.EMPTY;
            e.printStackTrace();
        }
        return font != null ? font : BitmapFont.EMPTY;
    }

    static {
        Path path = ((ModContainer)FabricLoader.getInstance().getModContainer("map-canvas-api").get()).getPath("fonts");
        BitmapFont includeSpace = DefaultFonts.read(path.resolve("include/space.mcaf"));
        VANILLA = REGISTRY.register(class_2960.method_60654((String)"minecraft:default"), DefaultFonts.read(path.resolve("vanilla.mcaf")));
        ALT = REGISTRY.register(class_2960.method_60654((String)"minecraft:alt"), DefaultFonts.read(path.resolve("alt.mcaf")));
        ILLAGER_ALT = REGISTRY.register(class_2960.method_60654((String)"minecraft:illageralt"), DefaultFonts.read(path.resolve("illageralt.mcaf")));
        UNSANDED_BASE = REGISTRY.register(class_2960.method_60654((String)"unsanded:base"), DefaultFonts.read(path.resolve("unsanded.mcaf")));
        UNSANDED = REGISTRY.register(class_2960.method_60654((String)"unsanded:full"), FontUtils.merge(UNSANDED_BASE, VANILLA));
        UNIFONT = REGISTRY.register(class_2960.method_60654((String)"unifont:default"), new MojangUnifontFont(CanvasFont.Metadata.create("Unifont", List.of("Roman Czyborra", "Paul Hardy"), "https://scripts.sil.org/OFL"), "unifont_all_no_pua-16.0.03", "https://resources.download.minecraft.net/cc/ccd5ac4767ce0a9c71d1dd62f2dc25449789b5dd", includeSpace));
        CanvasFont.Metadata jp = CanvasFont.Metadata.create("Unifont JP", List.of("Roman Czyborra", "Paul Hardy"), "https://scripts.sil.org/OFL");
        UNIFONT_JP = REGISTRY.register(class_2960.method_60654((String)"unifont:japanese"), new StackedLazyFont(new LazyCanvasFont[]{new MojangUnifontFont(jp, "unifont_jp_patch-16.0.03", "https://resources.download.minecraft.net/59/590470ab0f17afb73a4e41d9cb56fdbe069d275a", includeSpace), UNIFONT}, jp));
        REGISTRY.register(class_2960.method_60654((String)"minecraft:uniform"), UNIFONT);
    }
}

