/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.mapcanvas.api.utils.ViewUtils;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11719;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5224;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public final class FontRegistry {
    private final class_2960 defaultFontId;
    private final Map<class_2960, CanvasFont> fonts = new HashMap<class_2960, CanvasFont>();
    private CanvasFont defaultFont = BitmapFont.EMPTY;

    public FontRegistry() {
        this.defaultFontId = class_2960.method_60654((String)"minecraft:default");
    }

    public FontRegistry(class_2960 defaultFont) {
        this.defaultFontId = defaultFont;
    }

    public <T extends CanvasFont> T register(class_2960 identifier, T font) {
        if (this.fonts.containsKey(identifier)) {
            throw new RuntimeException("Font " + String.valueOf(identifier) + " is already registered!");
        }
        this.fonts.put(identifier, font);
        if (this.defaultFontId.equals((Object)identifier)) {
            this.defaultFont = font;
        }
        return font;
    }

    public CanvasFont getDefaultedFont(@Nullable class_2960 font) {
        return this.fonts.getOrDefault(font, this.defaultFont);
    }

    public CanvasFont getFontOrElse(@Nullable class_2960 font, CanvasFont orElse) {
        return this.fonts.getOrDefault(font, orElse);
    }

    @Nullable
    public CanvasFont getFont(@Nullable class_2960 font) {
        return this.fonts.get(font);
    }

    public Collection<class_2960> fonts() {
        return this.fonts.keySet();
    }

    public void drawText(DrawableCanvas canvas, class_2561 text, int x, int y, double size, CanvasColor defaultColor) {
        this.drawText(canvas, text, x, y, size, defaultColor, CanvasColor.CLEAR);
    }

    public void drawText(DrawableCanvas canvas, class_2561 text, int x, int y, double size, CanvasColor defaultColor, CanvasColor shadowColor) {
        this.drawText(canvas, text, x, y, size, defaultColor, shadowColor, (int)(size / 8.0));
    }

    public void drawText(final DrawableCanvas canvas, class_2561 text, final int x, final int y, final double size, final CanvasColor defaultColor, final CanvasColor shadowColor, final int shadowOffset) {
        final int pixel = (int)(size / 8.0);
        text.method_30937().accept(new class_5224(){
            private int posX = 0;

            public boolean accept(int index, class_2583 style, int codePoint) {
                CanvasColor color;
                int startX = this.posX;
                CanvasColor canvasColor = color = style.method_10973() != null ? CanvasUtils.findClosestColor(style.method_10973().method_27716()) : defaultColor;
                CanvasColor shadow = style.method_65301() != null ? CanvasUtils.findClosestColorARGB(style.method_65301()) : (shadowColor == CanvasColor.CLEAR_FORCE ? CanvasUtils.findClosestColor(class_9848.method_61321((int)(style.method_10973() != null ? style.method_10973().method_27716() : defaultColor.getRgbColor()), (float)0.25f)) : shadowColor);
                class_11719 class_117192 = style.method_27708();
                if (class_117192 instanceof class_11719.class_11721) {
                    DrawableCanvas localCanvas;
                    class_11719.class_11721 font1 = (class_11719.class_11721)class_117192;
                    CanvasFont font = FontRegistry.this.getDefaultedFont(font1.comp_4590());
                    int yPos = y;
                    if (style.method_10966()) {
                        yPos = (int)(size / 8.0 * 2.0);
                        localCanvas = ViewUtils.skewY(ViewUtils.shift(canvas, 0, y - yPos), -4.0 / size);
                    } else {
                        localCanvas = canvas;
                    }
                    if (shadow != CanvasColor.CLEAR) {
                        if (style.method_10984()) {
                            font.drawGlyph(localCanvas, codePoint, x + this.posX + 2 + shadowOffset, yPos + shadowOffset, size, 0, shadow);
                        }
                        font.drawGlyph(localCanvas, codePoint, x + this.posX + shadowOffset, yPos + shadowOffset, size, 0, shadow);
                    }
                    if (style.method_10984()) {
                        font.drawGlyph(localCanvas, codePoint, x + this.posX + 2, yPos, size, 0, color);
                    }
                    this.posX += font.drawGlyph(localCanvas, codePoint, x + this.posX, yPos, size, style.method_10984() ? 3 : 2, color);
                    if (codePoint == 32 && style.method_10984()) {
                        ++this.posX;
                    }
                } else {
                    BitmapFont.Glyph glyph;
                    BitmapFont.Glyph glyph2 = glyph = style.method_27708() instanceof class_11719.class_11881 ? BitmapFont.Glyph.PLAYER : BitmapFont.Glyph.ATLAS;
                    if (shadow != CanvasColor.CLEAR) {
                        glyph.draw(canvas, x + this.posX + shadowOffset, y + shadowOffset, size, 0, shadow);
                    }
                    this.posX += glyph.draw(canvas, x + this.posX, y, size, style.method_10984() ? 1 : 0, color);
                }
                if (shadow != CanvasColor.CLEAR) {
                    if (style.method_10965()) {
                        CanvasUtils.fill(canvas, x + startX - pixel + shadowOffset, y + pixel * 9 - pixel + shadowOffset, x + this.posX + shadowOffset, y + pixel * 9 + shadowOffset, shadow);
                    }
                    if (style.method_10986()) {
                        CanvasUtils.fill(canvas, x + startX - pixel + shadowOffset, (int)((double)y + Math.ceil(size) / 2.0) + shadowOffset, x + this.posX + shadowOffset, (int)((double)y + Math.ceil(size) / 2.0) + pixel + shadowOffset, shadow);
                    }
                }
                if (style.method_10965()) {
                    CanvasUtils.fill(canvas, x + startX - pixel, y + pixel * 9 - pixel, x + this.posX, y + pixel * 9, color);
                }
                if (style.method_10986()) {
                    CanvasUtils.fill(canvas, x + startX - pixel, (int)((double)y + Math.ceil(size) / 2.0), x + this.posX, (int)((double)y + Math.ceil(size) / 2.0) + pixel, color);
                }
                return true;
            }
        });
    }

    public int getWidth(class_2561 text, final double size) {
        var tmp = new class_5224(){
            private int posX = 0;

            public boolean accept(int index, class_2583 style, int codePoint) {
                class_11719 class_117192 = style.method_27708();
                if (class_117192 instanceof class_11719.class_11721) {
                    class_11719.class_11721 font1 = (class_11719.class_11721)class_117192;
                    CanvasFont font = FontRegistry.this.getDefaultedFont(font1.comp_4590());
                    this.posX += font.getGlyphWidth(codePoint, size, style.method_10984() ? 3 : 2);
                    if (codePoint == 32 && style.method_10984()) {
                        ++this.posX;
                    }
                } else {
                    BitmapFont.Glyph glyph = style.method_27708() instanceof class_11719.class_11881 ? BitmapFont.Glyph.PLAYER : BitmapFont.Glyph.ATLAS;
                    this.posX += glyph.getWidth(size, style.method_10984() ? 1 : 0);
                }
                return true;
            }
        };
        text.method_30937().accept(tmp);
        return tmp.posX;
    }
}

