/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.impl.font.AwtFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import eu.pb4.mapcanvas.impl.font.LazyFont;
import eu.pb4.mapcanvas.impl.font.StackedFont;
import eu.pb4.mapcanvas.impl.font.StackedLazyFont;
import eu.pb4.mapcanvas.impl.font.serialization.RawBitmapFontSerializer;
import eu.pb4.mapcanvas.impl.font.serialization.UniHexFontReader;
import eu.pb4.mapcanvas.impl.font.serialization.VanillaFontReader;
import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class FontUtils {
    private FontUtils() {
    }

    public static CanvasFont merge(CanvasFont ... fonts) {
        return new StackedFont(fonts);
    }

    public static CanvasFont merge(CanvasFont.Metadata metadata, CanvasFont ... fonts) {
        return new StackedFont(fonts, metadata);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, ZipFile ... zipFile) {
        return VanillaFontReader.build(zipFile, identifier);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, CanvasFont.Metadata metadata, ZipFile ... zipFile) {
        return VanillaFontReader.build(zipFile, metadata, identifier);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, CanvasFont.Metadata metadata, Function<String, @Nullable InputStream> fileGetter) {
        return VanillaFontReader.build(fileGetter, metadata, identifier);
    }

    public static CanvasFont fromUniHexFormat(InputStream fontFile, CanvasFont.Metadata metadata) {
        try {
            return UniHexFontReader.build(fontFile, metadata);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return BitmapFont.EMPTY;
        }
    }

    public static CanvasFont fromMapCanvasFontFormat(InputStream stream) {
        BitmapFont font = RawBitmapFontSerializer.read(stream);
        return font != null ? font : BitmapFont.EMPTY;
    }

    public static CanvasFont fromAwtFont(Font font) {
        return new AwtFont(font, CanvasFont.Metadata.create(font.getName(), List.of(), "A font"), false);
    }

    public static CanvasFont fromAwtFont(Font font, CanvasFont.Metadata metadata) {
        return new AwtFont(font, metadata, false);
    }

    public static CanvasFont fromAwtFont(Font font, boolean antiAliasing) {
        return new AwtFont(font, CanvasFont.Metadata.create(font.getName(), List.of(), "A font"), antiAliasing);
    }

    public static CanvasFont fromAwtFont(Font font, CanvasFont.Metadata metadata, boolean antiAliasing) {
        return new AwtFont(font, metadata, antiAliasing);
    }

    public static CanvasFont fromTrueTypeFont(InputStream stream) throws Exception {
        return FontUtils.fromAwtFont(Font.createFont(0, stream));
    }

    public static CanvasFont fromTrueTypeFont(InputStream stream, CanvasFont.Metadata metadata) throws Exception {
        return FontUtils.fromAwtFont(Font.createFont(0, stream), metadata, false);
    }

    public static CanvasFont fromTrueTypeFont(InputStream stream, boolean antiAliasing) throws Exception {
        return FontUtils.fromAwtFont(Font.createFont(0, stream), antiAliasing);
    }

    public static CanvasFont fromTrueTypeFont(InputStream stream, CanvasFont.Metadata metadata, boolean antiAliasing) throws Exception {
        return FontUtils.fromAwtFont(Font.createFont(0, stream), metadata, antiAliasing);
    }

    public static boolean toMapCanvasFontFormat(CanvasFont font, OutputStream stream) {
        BitmapFont bitmapFont = BitmapFont.tryConvert(font);
        if (bitmapFont != null) {
            return RawBitmapFontSerializer.write(bitmapFont, stream);
        }
        return false;
    }

    public static boolean isBitmapFont(CanvasFont font) {
        StackedLazyFont stackedLazyFont;
        StackedFont stackedFont;
        LazyFont lazyFont;
        return font instanceof BitmapFont || font instanceof LazyFont && FontUtils.isBitmapFont((lazyFont = (LazyFont)font).font()) || font instanceof StackedFont && Arrays.stream((stackedFont = (StackedFont)font).fonts()).filter(Predicate.not(FontUtils::isBitmapFont)).findAny().isEmpty() || font instanceof StackedLazyFont && Arrays.stream((stackedLazyFont = (StackedLazyFont)font).fonts()).filter(Predicate.not(FontUtils::isBitmapFont)).findAny().isEmpty();
    }
}

